;------------------------------------------------------------------------------
; File: TEST_MICS.PRO	Executes all CAMMICE MICS routines on LZ data file
; Revision: 6/20/97     J L Roeder
;------------------------------------------------------------------------------
pro test_mics, filename

;	Open CAMMICE Level Zero file
if n_elements(filename) eq 0 then filename=pickfile()
print,'MICS Testing File: ',filename
opn_lz, filename

cmd = ' '
read,'Process entire file (y/n)? ',cmd
if strlowcase( cmd) ne 'y' then begin
	rec1 = 0
	rec2 = 0
	read,'Enter Record Range: ', rec1, rec2
	set_records,[rec1,rec2]
endif


;	MICS Direct Events
get_mde, times, eng, tof, esa, m, moq, err
print
print, 'MICS Direct Event Arrays'
help, times, eng, tof, esa, m, moq, err

; 	MICS Sectored Rate Scalers
set_mrates, indgen(11)
get_msrates, times, delta, sectors, esa, chans, cnts, err
print
print, 'MICS Sectored Rate Scaler Arrays'
help, times, delta, sectors, esa, chans, cnts, err

; 	MICS Sectored Rate Scalers with Pitch Angles
set_mrates, indgen(11)
pa_mode = 0	; 0 -> 0-180 degrees, 1 -> 0-360 degrees
get_msrts, pa_mode, times, delta, sectors, esa, chans, cnts, pang, err
get_msrates, times, mf, sectors, esa, chans, cnts, err
print
print, 'MICS Sectored Rate Scaler Arrays with Pitch Angles'
help, pa_mode, times, delta, sectors, esa, chans, cnts, pang, err
print, 'Pitch Angle Min/Max',min(pang),max(pang)

; 	MICS Spin-Averages Rate Scalers
set_msrates, indgen(16)
get_mtotrts, times, esa, chans, cnts, err
print
print, 'MICS Spin-Averaged Rate Scaler Arrays'
help, times, esa, chans, cnts, err

;	MICS Singles
get_msing, esa, timesa, sectora, cntsa, timesb, sectorb, cntsb, err
print
print, 'MICS Singles Arrays'
help, esa, timesa, sectora, cntsa, timesb, sectorb, cntsb, err

;	MICS Matrix Scalers
get_mmatrx, times, cnts, odd, err
print
print, 'MICS Matrix Scaler Arrays'
help, times, cnts, odd, err

;	MICS Sun Sector and Other Info
get_msun, times, msun, err
print
print, 'MICS Sun Sector and Other Info'
help, times, msun, err

;	MICS DPU Status
get_mdpustat, times, mdpustat, err
print
print, 'MICS DPU Status Arrays'
help, times, mdpustat, err

;	MICS DPU Housekeeping
get_mdpuhk, times, mdpuhk, err
print
print, 'MICS DPU Housekeeping Arrays'
help, times, mdpuhk, err

;	MICS Sensor Status
get_micsstat, times, micsstat, err
print
print, 'MICS Sensor Status Arrays'
help, times, micsstat, err

;	MICS Sensor Housekeeping
get_micshk, times, micshk, err
print
print, 'MICS DPU Housekeeping Arrays'
help, times, micshk, err

;	Close Level Zero File
cls_lz

end
