;------------------------------------------------------------------------------        
; File: UNPK_CAM.PRO    CAMMICE Level Zero Unpacking Routines              
; Revision: 02/15/96    J L Roeder              
;-----------------------------------------------------------------------------        
; Routines:        
;       unpack_cam      Unpacks CAMMICE Level Zero Record into DRH and data        
;------------------------------------------------------------------------------        
pro unpack_cam, rec_numb, err              
        
;       Unpacks a CAMMICE Level Zero Record into a Data Record Header and              
;       and the various types of instrument data              
        
; Inputs:              
;       rec_numb        Record number, first record is zero              
        
; BLOCK: camLZ_data              
;       recnumb         Record number of data              
;       drh             Data record header              
;       hk              Housekeeping bytes dim 250 x 2             
;       subcom          Subcom (Loose) bytes dim 250 x 2             
;       mics_fixed      Fixed-Column MICS Science Allocation, dim 50 x 15              
;       hit_fixed       Fixed-Column HIT Science Allocation, dim 50 x 15             
        
common camLZ_data, recnumb, drh, hk, subcom, mics_fixed, hit_fixed             
   
;   Set common block record number to requested record   
recnumb = rec_numb   

;   Extract the record from the CAMMICE LZ buffer           
cam_record, recnumb, drh, hk, subcom, mics_fixed, hit_fixed, err           
       
;   Check if record found in buffer        
if err ne '' then begin              
        
;   Load buffer with several CAMMICE Level Zero records beginning  
;   with the requested record  
    buff_cam, rec_numb, err           
       
;   Try again           
    if err eq '' then begin 
 
;       Set common block record number to requested record   
        recnumb = rec_numb   
 
;       Extract the record from buffer 
        cam_record, recnumb, drh, hk, subcom, mics_fixed, hit_fixed, err           

    endif
                            
endif    
   
end       
       
