;------------------------------------------------------------------------------
; File:  DECOMPRS.PRO	Routines to decompress CAMMICE counts
; Revision: 09/06/95	J L Roeder
;-------------------------------------------------------------------------------
; Routines:
;	compute_Lut	Computes Look-up Table for count decompression
;	decomprs_cnts	Decompresses Count array
;-------------------------------------------------------------------------------
pro compute_Lut, Lut

;	Computes Look-up Table for count decompression

; Input: None

; Output:
;	LUT		Longword array of counts dim 256 for look-up

Lut = findgen( 256)

exponent = ishft( fix( Lut), -4)
mantissa = fix( Lut) mod 16

ge2 = where( exponent ge 2)
Lt2 = where( exponent Lt 2)

Lut( Lt2) = exponent( Lt2) * 16 + mantissa( Lt2)
Lut( ge2) = (mantissa( ge2) + 16.5) * (2 ^ (exponent(ge2) - 1)) - .5

Lut = long( Lut)

end
;-------------------------------------------------------------------------------
pro decomprs_cnts, counts

;	Decompress counts from lookup table in common block
;	Set 255B compressed counts to -1B.
;	Note output replaces input.

; Input/Output:
;	counts		Byte array of counts

common Lookup, Lut

;	First time compute table
if n_elements( Lut) eq 0L then compute_Lut, Lut

;	Decompress counts using lookup
cnts = counts
cnts = Lut( cnts)

;	Fill lost data with -1's
jlost = where (counts eq 255B)
if jlost(0) ne -1L then cnts( jlost) = -1L

;	Transfer result to output array
counts = cnts

end 
