;******************************************************************************
;* file papcoadd_polar_ceppad
;*      papcoadd_polar_ceppad
;* end
;*
;* this files contains all the collected routines which have to be added in
;* for ceppad. 
;*
;* CEPPAD is a a sub-menu for several CEPPAD plot types. To inform PACPCO
;* which plot-types are supported in this file, the plot types are listed at
;* the top of this file: The location of this information in critical as it is
;* read by papco.
;*
;*    Those procedures are contained:
;*
;*    PRO addplottype_polar_ceppad,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_polar_ceppad, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO descriptor_polar_ceppad, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_polar_ceppad
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_polar_ceppad, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from 
;*	     papco_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_polar_ceppad, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure performs the actual read call and the plot call
;*           for this plottype
;******************************************************************************

;******************************************************************************
;* PROCEDURE:     
;*      PRO addplottype_polar_ceppad,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:       
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*
;* OUTPUTS: 
;*   	pb_plottype	the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for subtypes.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addplottype_polar_ceppad,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*     modified February 1995, Reine Friedel, added SURVEY modes
;******************************************************************************
pro addplottype_polar_ceppad,plottypes_base,buttonGeometry,pdm_plottype

MenuDesc544 = [ $
      { CW_PDMENU_S, 3, strcenter('POLAR CEPPAD',12) }, $ 
      { CW_PDMENU_S, 0, ' configure polar ceppad' }, $
      { CW_PDMENU_S, 2, ' plot polar ceppad' } $
  ]

pdm_plottype = CW_PDMENU(plottypes_base, MenuDesc544, $
                         UVALUE='pdm_polar_ceppad')

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_polar_ceppad
;*
;* DESCRIPTION:  
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*      panelEditor must be set to the name of the panel editor routine
;*
;* INPUTS:       
;*	event		event value of papco main window. This is
;*                      only used if there are plot sub_types, 
;*                      for example see papcoadd_crres_plots
;*
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addpanel_polar_ceppad
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
PRO addpanel_polar_ceppad, event

COMMON get_error, get_err_no, get_err_msg
  
panelKind='polar_ceppad'
  
r_module_config, panelKind, config_data, msg
if (get_err_no ne 0) and (event.value ne 1) then begin
    message,'You need to configure the module first', /cont
    papco_module_configure,panelKind
    return
ENDIF

  CASE Event.Value OF 
    1: BEGIN
        papco_module_configure, panelKind
    END    
    2: BEGIN
        panelEditor = panelKind+'_panel'
        defaults=papco_getPlotInfoStruct()
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    END
    3: BEGIN
        panelKind = panelKind+'_overview'
        panelEditor = panelKind+'_panel'
        defaults=papco_getPlotInfoStruct()
        papco_Add_Plot, panelEditor, panelKind, initialPlotInfo=defaults
    END
    ELSE: BEGIN 
        message,'Nothing defined for this submenu entry', /cont
        return
    END    
ENDCASE

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_polar_ceppad, plottable
;*
;* DESCRIPTION:  
;*	Sets a variable to indicate plottable without orbit.
;*
;* INPUTS:       
;*	none
;*
;* OUTPUTS: 
;*   	plottable	a boolean 0 if plottable only by CRRES orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	plottable_polar_ceppad, plottable
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro plottable_polar_ceppad, plottable &  plottable=1 & END

pro plottable_polar_ceppad_overview, plottable &  plottable=1 & END
  
  
;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_polar_ceppad, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that polar_cammice is capable of
;*      returning data from it's plot routine into a standard PAPCO
;*      array structure. Used for the scratch pad utility module.
;*      
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_polar_cammice.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                                1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_polar_cammice, canget
;*
;* MODIFICATION HISTORY:       
;*      written November 1997, Reiner Friedel
;******************************************************************************
pro canget_polar_ceppad, canget
canget=  1      ;1: output feature 0: feature disabled
END

pro canget_polar_ceppad_overview, canget
canget=  1      ;1: output feature 0: feature disabled
END
 
;******************************************************************************
;* PROCEDURE:     
;*      PRO descriptor_polar_ceppad, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:       
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	descriptor_polar_ceppad, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
PRO descriptor_polar_ceppad, plotInfo, descriptStr

COMMON polar_ceppad ;see polar_ceppad_commons.pro for contents of this block

control = *plotinfo.USR_PTR1

index = control.product < (n_elements(typeNames)-1)
inst = typeNames(index)
product = 'SPIN_'+varprt(control.sectors)+'Z'+varprt(control.spins)

descriptStr=descriptStr+inst+'_'+product
  
END

PRO descriptor_polar_ceppad_overview, plotInfo, descriptStr

descriptStr=descriptStr

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_polar_ceppad, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*	This procedure performs the actual data read call and the plot call
;*      for this plottype.
;*      
;*
;* INPUTS:       
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data
;*                      in a panel, eg. to draw spectra, distribution functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*
;   here the type of mouse action is checked according to the slice_type flag
;   set by the user. Depending on which bits he set, the action is enabled.
      
;   slice_type:   Selects which slices are supported and for which slice
;                 routines have been written.
;                 This is an integer logical with 16 swittches. Currently
;                 there are 5 papco slices. You may extend this by
;                 further USER slices up to a total of 16 slices.
;                     0 = disable all slices
;                     1 = papco Zoom                 (2^0)
;                     2 = papco View Slice           (2^1)
;                     4 = papco Access level Zero    (2^2)
;                     8 = papco Write Paneldata      (2^3)
;                    16 = papco Hair Cursor          (2^4)
;                    32 = USER slice A or not used   (2^5)
;                    64 = USER slice B or not used   (2^6)
;                    "     "     "   "  "  "    "      "    
;                 32768 = USER slice Z or not used  (2^15)
;                        
;   You can support more than one type of slice by arithmetically adding the
;   options, eg slice_type=1+4  support Zoom and Level Zero
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	draw_polar_ceppad, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro draw_polar_ceppad, Panel, PlotInfo, orbitNo, $
                       get_data_call, slice_type, IsRead, OUTPUT=OUTPUT

COMMON extra, extra_PlotInfo
COMMON polar_ceppad ;see polar_cep_commons.pro for contents of this block
   
control = *plotinfo.USR_PTR1
get_data_call='' ; use new scheme - call whole of draw routine, incl .read
  
slice_assigned_value_1=papco_slice_value('USER 3DD Slice')
slice_Type=1+2+8+16
slice_Type = slice_Type + slice_assigned_value_1

IF NOT IsRead THEN BEGIN ; check if data has already been read
    r_polar_ceppad, PlotInfo
    IF papco_Draw_CheckResult(PlotInfo.panelKind, $
                              panel, orbitNr, PlotInfo.typeVector, $
                              PlotInfo.channel)   THEN IsRead=1
ENDIF
    
IF IsRead THEN BEGIN
    IF NOT control.reload THEN IsRead=0
    p_polar_ceppad, panel, PlotInfo, OUTPUT=OUTPUT, _EXTRA=extra_PlotInfo
ENDIF

END


;******************************************************************************
pro draw_polar_ceppad_overview, panelVector, currPlotInfo, orbitNo, $
                          get_data_call, slice_type, IsRead

common extra, extra_PlotInfo

   get_data_call= "r_cep_lav, type"
   slice_Type=1+16

   IF NOT IsRead THEN BEGIN
      r_cep_lav, currPlotInfo.typeVector
      IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                                panelVector, orbitNr, $
                                currPlotInfo.typeVector, $
                                currPlotInfo.channel) $
      THEN  IsRead=1 ELSE return

   ENDIF

   p_cep_lav, panelVector, currPlotInfo.typeVector, $
              currPlotInfo.ioptions(17:19),  _EXTRA=extra_PlotInfo

END
