pro cep_cdlz_to_l1

print,'Batch job to create level one files'
print,'from CEPPAD level zero files on CDROM'
print,''
spawn,'smount /cdrom'

;check if CDROM is correct, paths are set...

path=getenv('PO_CEP_LZ_DIR')
   if strlen(path) eq 0 then begin
      print,'Environmental variable (PO_CEP_LZ_DIR) for lz data path not set'
      return
   endif
   if strpos(path,'cdrom') ne 1 then begin
      print,'Environmental variable (PO_CEP_LZ_DIR) not pointing to cdrom:'
      print,'PO_CEP_LZ_DIR = ',path
      return
   endif
   newfiles=findfile('/cdrom/data/po/cep/lz/*.dat',count=nof)
   if nof eq 0 then begin
      print, 'no data files found - is CDROM loaded?'
      print, '                      is correct cdrom loaded?'
      print, '                      is cdrom mounted?'
      return
   endif

;get sequence and volume of CD
   get_cdno, cdno

;check if contents of CDROM lz has already been processed.

   dates=strarr(n_elements(newfiles))
   newdates=strarr(n_elements(newfiles))

   for i=0,n_elements(newfiles) -1 do begin
      dates(i)=strmid(newfiles(i),22,12)
      newdates(i)=cep_get_l1day(dates(i))
   endfor

   path=getenv('PO_CEP_L1_DIR')
   oldfiles=findfile(path+'/PO_CEP_L1*',count=nof)
   for i=0,n_elements(newfiles) -1 do begin
      check=strpos(oldfiles,newdates(i))
      if max(check) eq -1 then begin
         print,'day not processed yet: ',newdates(i)
         PRINT, ''
  ; change to level 1 directory
         CD, GETENV ( 'PO_CEP_L1_DIR' ), CURRENT=currentdir
         PRINT, 'Converting level 0 file : ', newfiles(i)
         PRINT, '                          day ',newdates(i),' to level 1'
         PRINT, ''
    ; create level 1 files
    ; arguments : filename of level 0 data
    ;             dummy 
    ;             dummy
    ;             output level
         t=systime(1)
         close,/all
         make_level_1, newfiles(i)
         print,'time taken for ',newdates(i),' : ',(systime(1)-t)/60,' Minutes'
  ; add new l1 done to list
         addtolist,cdno,newdates(i),dates(i),'L1  O.K.    ', path
  ; change back to old directory
         CD, currentdir
      endif else begin
         print,'day already processed: ',newdates(i)            
         addtolist,cdno,newdates(i),dates(i),'L1  O.K.    ', path
      endelse
   endfor

spawn,'sumount /cdrom'
spawn,'eject cdrom'

end
