;runs ral software to add the pitch angle tags to if files.

PRO cep_make_ral_pitch, TYPE = TYPE, DATE1 = DATE1, DATE2 = DATE2

COMMON get_error, get_err_no, get_err_msg

papco, /set_only

IF keyword_set(DATE1) THEN date1 = DATE1 ELSE date1 = 19960305l
IF keyword_set(DATE2) THEN date2 = DATE2 ELSE date2 = 20030731l

IF NOT (papco_check_data_env('PO_CEP_IF_DIR', path=if_path)) then return
IF keyword_set(TYPE) THEN type = TYPE ELSE $
   type = 'PO_CEP_RAL_CLEAN_SURVEY_IES_????????.DAT'
 
files = file_search(if_path+'/*/*'+type, count = c)
IF c EQ 0 THEN BEGIN
    message, 'No files found', /info & return
ENDIF

p = strpos(type, '.DAT')
IF p EQ -1 THEN BEGIN
    message, 'TYPE must end in .DAT', /info
    return
ENDIF 
path_len = strlen(if_path)+5
dates = strmid(files, path_len+p-8, 8)
if_name = strmid(type, 0, p-8)

FOR i = 0, c-1 DO BEGIN
    
    IF long(dates(i)) LE date1 THEN CONTINUE 
    IF long(dates(i)) GE date2 THEN BREAK 

    ;get pitch angles

    ies_reprocess, /PA, FILES = files(i)
    IF get_err_no NE 0 THEN goto, next_day

    ;output is file with 6 digit date in if directory. Rename and move
    ;to if/yyyy/ dir

    yymmdd = strmid(dates(i), 2, 6)
    yyyy = strmid(dates(i), 0, 4)+'/'

    IF NOT file_test(if_path+yymmdd+'.dat') THEN continue

    file_move, if_path+yymmdd+'.dat', $
      if_path+yyyy+if_name+'PA_MF_'+dates(i)+'.DAT', $
      /overwrite, /verb

    next_day:
    get_err_no = 0
    
ENDFOR

END


