;******************************************************************************
; RAL CEPPAD software initialization file
; Last edit: May 02, 2003 - include PO_CEP_IF_DIR for pitch work
;******************************************************************************

print, '--- Startup file for the RAL CEPPAD software ---------------'
  
base_code = papco_getenv('PAPCO_MODULES')+$
            'polar_ceppad/plot_read/data_processing/sw/'

;Base data is set relative to $PAPCO_DLNK
base_data = '$PAPCO_DLNK/polar/ceppad/'

cdhf_base = '/n/tempest/projects/polar/CDHF/'
cdhf_base = base_data+'/CDHF/'

; Note: As this code is in the polar ceppad module tree, a path to it is set
; automatically when the module is included. If you run the code
; outside of PAPCO, you need to set a path to the code, as shown
; below
;
;print, ''
;print, '--- Expanding IDL search path ------------------------------'
;print, ''
;print, '    Added path: +'+base_code
;!path = !path+':'+expand_path('+'+base_code)

; set base dir for local ceppad data tree
SETENV, 'PO_CEP_BASE='+base_data

print, ''
print, '--- Compling RAL code and setting paths---------------------'
print, ''

;******************************************************************************
; POLAR CEPPAD environment variables NB! need full directory path 
;******************************************************************************

; default directory containing POLAR level 0 data
SETENV, 'PO_CEP_DEFAULT_LZ_DIR='+base_data+'local_l0/'

; directory containing level 0 data
SETENV, 'PO_CEP_LZ_DIR='+base_data+'local_l0/'
; directory for level 1 data
SETENV, 'PO_CEP_L1_DIR='+base_data+'local_l1/'

; directory for RAL intermediate format data output
SETENV, 'PO_CEP_IF_DIR='+base_data+'if/'
; directory for RAL intermediate format HISTe data output
SETENV, 'PO_CEP_HISTe_DIR='+base_data+'if/'     
; directory for RAL intermediate format HISTp data output 
SETENV, 'PO_CEP_HISTp_DIR='+base_data+'if/'
; directory for RAL intermediate format IES data output             
SETENV, 'PO_CEP_IES_DIR='+base_data+'if/'
; directory for RAL intermediate format IPS data output                  
SETENV, 'PO_CEP_IPS_DIR='+base_data+'if/'               
; directory for RAL intermediate format MF data output
SETENV, 'PO_CEP_MF_DIR='+base_data+'if/'              
; directory for RAL intermediate format HK data output
SETENV, 'PO_CEP_HK_DIR='+base_data+'if/'

; directory for RAL pedestal data output
SETENV, 'PO_CEP_PD_DIR='+base_data+'if/'

; directories for ephemeris data 
SETENV, 'PO_CEP_EPH_DIR=$PAPCO_DLNK/polar/eph/raleph/'
SETENV, 'PO_CEP_OR_DEF_DIR=$PAPCO_DLNK/polar/eph/def/or/'
SETENV, 'PO_CEP_OR_PRE_DIR=$PAPCO_DLNK/polar/eph/pre/or'
SETENV, 'PO_CEP_OR_DIR=$PAPCO_DLNK/polar/eph/' 
SETENV, 'PO_CEP_AT_DEF_DIR=$PAPCO_DLNK/polar/eph/def/at/'
SETENV, 'PO_CEP_AT_PRE_DIR=$PAPCO_DLNK/polar/eph/pre/at'
SETENV, 'PO_CEP_AT_DIR=$PAPCO_DLNK/polar/eph/'

; directory for MFE cdf data 
SETENV, 'PO_CEP_MFE_DIR=$PAPCO_DLNK/polar/mfe/cdf/'
; directory for CDF ephemeris data 
SETENV, 'PO_CEP_EPH_CDF_DIR=$PAPCO_DLNK/polar/eph/ephcdf/'

; directory containing telemetry table file and calibration files
SETENV, 'PO_CEP_TM_TABLE_DIR='+base_code+'tm/'	

; directory for RAL intermediate format data input to display program
SETENV, 'IES_DATA_DIR='+base_data+'if/'		

;note: PAPCO uses the same time library and sets this path
; directory containing leap_seconds.dat file
;SETENV, 'TIME_CONV='+base_code+'cdssw/time/'	

; default directory for PNG results output
SETENV, 'PO_CEP_PNG_DIR='+base_data+'results/'
; default directory for GIF results output
SETENV, 'PO_CEP_GIF_DIR='+base_data+'results/'
; default directory for postscript results output
SETENV, 'PO_CEP_PS_DIR='+base_data+'results/'
; default directory for text results output
SETENV, 'PO_CEP_TXT_DIR='+base_data+'results/'

; default directory for Ceppad PNG movie results output
SETENV, 'PO_CEP_MV_DIR='+base_data+'results/'
; default directory for Ceppad pedestal plot results output
SETENV, 'PO_CEP_PED_DIR='+base_data+'results/'


;******************************************************************************
; compile routines - needs idl search path including the source directory!
;@cep_compile
;@ies_compile
;******************************************************************************
print, ''
print, '--- RAL DATA  path env. var. now set: --------------------------'
print,''
print, '    PO_CEP_LZ_DIR	: ',getenv('PO_CEP_LZ_DIR')
print, '    PO_CEP_L1_DIR	: ',getenv('PO_CEP_L1_DIR')
print, '    PO_CEP_IF_DIR	: ',getenv('PO_CEP_IF_DIR')
print, '    PO_CEP_HISTe_DIR	: ',getenv('PO_CEP_HISTe_DIR')
print, '    PO_CEP_HISTp_DIR	: ',getenv('PO_CEP_HISTp_DIR')
print, '    PO_CEP_IES_DIR	: ',getenv('PO_CEP_IES_DIR')
print, '    PO_CEP_IPS_DIR 	: ',getenv('PO_CEP_IPS_DIR')
print, '    PO_CEP_MF_DIR	: ',getenv('PO_CEP_MF_DIR')
print, '    PO_CEP_HK_DIR	: ',getenv('PO_CEP_HK_DIR')
print, '    PO_CEP_TM_TABLE_DIR : ',getenv('PO_CEP_TM_TABLE_DIR')
print, '    IES_DATA_DIR	: ',getenv('IES_DATA_DIR')
print, '    TIME_CONV		: ',getenv('TIME_CONV')
print, '    PO_CEP_GIF_DIR	: ',getenv('PO_CEP_GIF_DIR')
print, '    PO_CEP_PS_DIR	: ',getenv('PO_CEP_PS_DIR')
print, ''

;******************************************************************************

