;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_CHK_MONOTONIC
;
; Purpose     :	Checks array increases monotonicly.
;
; Explanation :	.
;
; Use         : < ies_sp_plot, x, y, maximum, type, CHSIZE=chsize, /DIVIDE, /SHOWCH, /COLORBAR >
;
; Inputs      : x       : DBLARR(npoints)    time for each sample
;               y       : FLTARR(npoints,1,nchannels) data values at each sample point for each channel
;               maximum : Maximum y value plotted.
;               type    : Integer giving type of plot
;                           type = 0 : spectral plot using polyfill
;                           type = 0 : spectral plot using image fill
;
; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    : CHSIZE    : FLTARR(1,nchannels) channel sizes in ADUs.
;               /DIVIDE   : indicates whether to divide by channel sizes or not.
;               /SHOWCH   : indicates whether to show real channel sizes or not
;               /COLORBAR : Display color bar in plot window.
;
; Calls       :	ies_getticks.
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 2/6/95
;
; Modified    :	Version 1.0, 1.0 22/10/97
;                            Fixed if only one sample in L1 file.              
;
; Version     :	Version 1.0, 22/10/97
;
;-
;**********************************************************

FUNCTION cep_chk_monotonic, array

  IF N_ELEMENTS(array) EQ 1 THEN RETURN,-1

  list = WHERE ( array ( 1: *) LT array (0:N_ELEMENTS(array)-2), count)

  IF count GT 0 THEN RETURN, 1+list ELSE RETURN, -1

END 