;+
; Project     :	POLAR - CEPPAD
;
; Name        :	cep_do_plot
;
; Purpose     :	Helper routine for cep movie.
;
; Explanation : Helper routine for cep movie.
;
; Use         : <  >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     :
;
;
; Opt. Outputs:
;
; Keywords    :
;
; Written     :	Version 0.0, Martin Carter, RAL, 9/5/97
;                 Adapted from cep survey.
;
; Modified    :	Version 0.1, 10/07/02
;                 Removed COLTAB keyword.
;               Version 0.2, 09/10/03
;                 Changed to ies get dir.
;
; Version     :	Version 0.2, 09/10/03
;-
;**********************************************************

PRO cep_do_plot, time_range, new_file, output_file, detector, pg_pos, not_end, NOAXIS=noaxis

  COMMON ies_draw_widget_block, input_header, input_data, header, data, output_info, output_chans, output_array, $
                                ids, dnfull, dnscroll, files, ephem

  ; extract data for detector

  IF NOT cep_extract(time_range, detector) THEN RETURN

  ; process data

  IF cep_calibrate(0, RANGE=[1.e-2,1.e5] ) THEN RETURN

  ; do spectral plots

  ; save current device

  devname = !D.NAME

  ; fiddle things

  header.xtitle  = 'UT:'

  ; get file name

  IF STRPOS(new_file,'.ps')  GE 0 THEN ps_file  = concat_dir ( ies_get_dir('MV',/POLAR ), new_file)
  IF STRPOS(new_file,'.png') GE 0 THEN png_file = concat_dir ( ies_get_dir('MV',/POLAR ), new_file)
  IF STRPOS(new_file,'.gif') GE 0 THEN gif_file = concat_dir ( ies_get_dir('MV',/POLAR ), new_file)

  ; plot data

  IF not_end THEN BEGIN
    IF ies_window_plot( devname, output_file, PNG=png_file, GIF=gif_file, POSTSCRIPT=ps_file, PG_POS=pg_pos, /NO_XAXIS, /NO_END, $
      HEADING = 'POLAR/CEPPAD MOVIE PLOT for ') THEN MESSAGE, 'ies_window_plot error', /TRACEBACK
  ENDIF ELSE BEGIN
    IF ies_window_plot( devname, output_file, PNG=png_file, GIF=gif_file, POSTSCRIPT=ps_file, PG_POS=pg_pos, NO_XAXIS=noaxis, $
      HEADING = 'POLAR/CEPPAD MOVIE PLOT for ') THEN MESSAGE, 'ies_window_plot error', /TRACEBACK
  ENDELSE

END


