;+
; Project     :	POLAR - CEPPAD
;
; Name        :	cep_get_at
;
; Purpose     :	Copies all CDF at files.
;
; Explanation : Uses environment variable ephemeris CDF and save file directories.
;               Copies all ephemeris files in CDF directory.
;
; Use         : <cep_get_at>
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : Copies ephemeris file if not already present.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display software.
;
; Prev. Hist. :	Adapted from cep_get_ephem.
;
; Written     :	Version 0.0, Martin Carter, RAL, 6/10/98
;
; Modified    :	Version 0.1, 11/07/02
;                 Used ies_spawn.
;               Version 0.2, 09/10/03
;                 Changed to ies get dir.
;                 Changed printout.
;
; Version     :	Version 0.2, 09/10/03
;-
;**********************************************************

PRO cep_get_at

  ; get ephemeris cdf file names from def directory

  def_dir = ies_get_dir('AT_DEF',/POLAR)

  cdf_files = FINDFILE( concat_dir ( def_dir, '*.cdf' ), COUNT=def_count )

  IF def_count EQ 0 THEN cdf_files = FINDFILE( STRUPCASE(concat_dir ( def_dir, '*.cdf' )), COUNT=def_count )

  IF def_count EQ 0 THEN cdf_files = FINDFILE( STRLOWCASE(concat_dir ( def_dir, '*.cdf' )), COUNT=def_count )

  ; loop through cdf files

  FOR f = 0, def_count-1 DO BEGIN

    cdf_file = cdf_files(f)

    bare_file = strip_dirname(cdf_file)

    ; get new file name

    new_file = concat_dir ( ies_get_dir('AT',/POLAR), 'def')
    new_file = concat_dir ( new_file, STRLOWCASE(bare_file))

    PRINT, 'Copying AT CDF file : ' + cdf_file

    IF ies_spawn('cp ' + cdf_file + ' ' + new_file) THEN MESSAGE, 'COPY FAILED'

  ENDFOR

  ; get cdf file names from pre directory

  pre_dir = ies_get_dir('AT_PRE',/POLAR)

  cdf_files = FINDFILE( concat_dir ( pre_dir, '*.cdf'), COUNT=pre_count )

  IF pre_count EQ 0 THEN cdf_files = FINDFILE( STRUPCASE(concat_dir ( pre_dir, '*.cdf')), COUNT=pre_count )

  IF pre_count EQ 0 THEN cdf_files = FINDFILE( STRLOWCASE(concat_dir ( pre_dir, '*.cdf')), COUNT=pre_count )

  ; loop through cdf files

  FOR f = 0, pre_count-1 DO BEGIN

    cdf_file = cdf_files(f)

    bare_file = strip_dirname(cdf_file)

    ; get new file name

    new_file = concat_dir ( ies_get_dir('AT',/POLAR), 'pre')
    new_file = concat_dir ( new_file, STRLOWCASE(bare_file))

    PRINT, 'Copying AT CDF file : ' + cdf_file

    IF ies_spawn('cp ' + cdf_file + ' ' + new_file) THEN MESSAGE, 'COPY FAILED'

  ENDFOR

  IF def_count EQ 0 AND pre_count EQ 0 THEN BEGIN

    PRINT, 'WARNING, No AT files found'

    RETURN

  ENDIF

END
