;**********************************************************
;+
; Project     :	POLAR - CEPPAD
;
; Name        :	CEP_GET_IFDIR
;
; Purpose     :	Sets up directory structure for RAL Intermediate format data.
;
; Explanation : The directory structure has format 'ifdir\iftype'.
;
; Use         : < dir = CEP_GET_IFDIR(iftype) >
;
; Inputs      : iftype : STRING IF data type
;
; Opt. Inputs : None.
;
; Outputs     : dir    : STRING directory name
;
; Opt. Outputs: None.
;
; Keywords    : None.
;;
; Written     :	Version 0.0, 11/04/03
;                 Adapted from rcs_get_ifdir.
;
; Modified    : Version 0.1, 09/10/03
;                 Changed to ies get dir.
;
; Version     :	Version 0.1, 09/10/03
;-
;**********************************************************

FUNCTION cep_get_ifdir, iftype

  dir = ies_get_dir('IF',/POLAR) 

  return, dir

  IF NOT file_test(dir, /dir) THEN BEGIN
    MESSAGE, 'IF data directory does not exist : ' + dir, /INFORMATIONAL
    RETURN, 0
  ENDIF

  dir = rcs_strtrim(concat_dir(dir,iftype))

stop

  IF NOT rcs_dir_exist(dir,/CREATE) THEN BEGIN
    MESSAGE, 'IF data sub-directory does not exist : ' + dir, /INFORMATIONAL
    RETURN, 0
  ENDIF

  RETURN, dir

END
