;**********************************************************
;+
; Project     :	POLAR - CEPPAD
;
; Name        :	CEP_IFNAME_DATATYPE
;
; Purpose     :	Gets IF datatype from input data file name.
;
; Explanation : Filename has form :  PO_CEP_RAL_CLEAN_SURVEY_IES_20010827.DAT
;
; Use         : < datetype = CEP_IF_DATATYPE( filename ) >
;
; Inputs      : filename : STRING name of IF data file
;
; Opt. Inputs : None.
;
; Outputs     : name : STRING IF datatype
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 12/03/02
;
; Modified    :	Version 0.1, 11/04/03
;                 Renamed.
;
; Version     :	Version 0.1, 11/04/03
;-
;**********************************************************

FUNCTION cep_ifname_datatype, filename

  file = strip_dirname(filename)

  RETURN, STRMID(file,11,STRPOS(file,'.DAT')-20)

END
