;**********************************************************
;+
; Project     :	POLAR - CEPPAD
;
; Name        :	CEP_IFNAME_DAY
;
; Purpose     :	Gets IF day from input data file name.
;
; Explanation : Filename has form :  PO_CEP_RAL_CLEAN_SURVEY_IES_20010827.DAT
;
; Use         : < day = CEP_IF_DAY( filename ) >
;
; Inputs      : filename : STRING name of IF data file
;
; Opt. Inputs : None.
;
; Outputs     : day  : STRING IF day in form yymmdd.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 12/03/02
;
; Modified    :	Version 0.1, 11/04/03
;                 Renamed.
;
; Version     :	Version 0.1, 11/04/03
;-
;**********************************************************


FUNCTION cep_ifname_day, filename

  name = strip_dirname(filename)

  RETURN, STRMID(name,STRPOS(name,'.DAT')-6,6)

END
