;+
; Project     :	POLAR - CEPPAD
;
; Name        :	cep_parse_l1day
;
; Purpose     :	Extracts the modified Julian day number from the level 1 file name.
;
; Explanation : Level 1 files have date format '19yyddd'
;               This routine converts this into the year and day number.
;
; Use         : < l1_mjulday = cep_parse_l1day ( l1_file ) >
;
; Inputs      : l1_file : STRING containing level 1 file name.
;
; Opt. Inputs : None.
;
; Outputs     : l1_mjulday  : Integer giving modified Julian day number.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	doy2utc.
;
; Common      :	None.
;
; Restrictions: None.
;
; Side effects:	None.
;
; Category    :	Display software.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 20/2/96
;
; Modified    :	Version 0.1, 29/2/96
;                  Converted to modified Julian day output.
;               Version 0.2, 17/3/99
;                  Made Y2K compliant and fixed problem if 19 in directory structure.
;               Version 0.3, 13/12/99
;                  Checked Y2K compliant.
;
; Version     :	Version 0.3, 13/12/99
;-
;**********************************************************

FUNCTION cep_parse_l1day, l1_file

  ; locate file date
  ; l1 files have either forms :
  ; PO_CEP_L1_IES_1996357_01.DAT.gz or PO_CEP_L1_HK_1996221.DAT.gz

  ; decide between forms

  pos = STRPOS ( l1_file, '.DAT' )

  IF pos LT 10 THEN MESSAGE, 'Invalid level 1 file name : ' + l1_file, /TRACEBACK

  IF STRMID( l1_file, pos-3, 1) EQ '_' THEN pos = pos - 10 ELSE pos = pos - 7

  l1_year = LONG ( STRMID ( l1_file, pos, 4 ) )

  l1_day  = LONG ( STRMID ( l1_file, pos+4, 3) )

  ; contruct corresponding CDS internal time

  utc = doy2utc ( l1_day, l1_year )

  RETURN, utc.mjd

END

