;**********************************************************
;+
; Project     :	POLAR - CEPPAD
;
; Name        :	CEP_SAVE_IFSET
;
; Purpose     :	Save a single RAL Intermediate format data set.
;
; Explanation : The IF data set is saved to a separate file in a
;               directory specified by the datatype.
;
; Use         : < CEP_SAVE_IFSET, input_header, input_data, name >
;
; Inputs      : input_header : STRUCTURE[] containing header info
;               input_data   : STRUCTURE[] containing data
;               day          : STRING day in form yymmdd.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 13/03/02
;
; Modified    :	Version 0.1, 11/04/03
;                 Renamed and changed directory structure.
;               Version 0.2, 13/10/03
;                 Made use of the default string length for STRMID.
;
; Version     :	Version 0.1, 11/04/03
;-
;**********************************************************

PRO cep_save_ifset, input_header, input_data, day

  datatype = STRMID(TAG_NAMES(input_data,/STRUCTURE_NAME),5,60)

  vpos = STRPOS(datatype,'_V',/REVERSE_SEARCH)

  IF vpos GE 0 THEN datatype = STRMID(datatype,0,vpos)

  datatype = ies_replace(datatype,'/','_')

  dir = cep_get_ifdir(STRMID(datatype,6))

  IF NOT KEYWORD_SET(dir) THEN RETURN

  name = day + '.dat'

  file = concat_dir(dir,name)

  rcs_text, 'SAVING IF DATA SET : '+file, /OVERRIDE

  IF !VERSION.RELEASE GE '5.4' THEN BEGIN

    SAVE, input_header, input_data, FILE=file, /COMPRESS

  ENDIF ELSE BEGIN

    SAVE, input_header, input_data, FILE=file

  ENDELSE

END
