;+
; Project     :	CLUSTER - PEACE
;
; Name        :	CEP_SMALL_PIXEL
;
; Purpose     : Returns array of flags indicating whether lut_map items are IES small pixels.
;
; Explanation :	Returns array of flags indicating whether lut_map items are IES small pixels.
;               If keyword LUT specified then returns 1 if small pixel else 0.
;               IF LUT specifes an array then returns an array of flags.
;
; Use         : < res = cep_small_pixel( header, LUT=lut ) >
;
; Inputs      : header  : STRUCTURE containg header information
;
; Opt. Inputs : None.
;
; Outputs     : res  : INTARR[] flags indicating whether header.lut_map are small pixels.
;                      IF LUT keyword used then
;                        INT or INTARR[] 1 if small pixel, 0 otherwise.
;
;
; Opt. Outputs:	None.
;
; Keywords    : luts    : INT or INTARR[nluts] 0:no_of_luts-1 LUT
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 04/12/03
;
; Modified    :
;
; Version     :	Version 0.0, 04/12/03
;-
;**********************************************************

FUNCTION cep_small_pixel, header, LUT=lut

  IF N_ELEMENTS(lut) EQ 0 THEN $
    RETURN, (header.lut_map MOD 2) EQ 0 $
  ELSE $
    RETURN, (header.lut_map[lut] MOD 2) EQ 0

END