;+
; Project     :	POLAR - CEPPAD
;
; Name        :	cep_survey_wrapper
;
; Purpose     :	Produces postscript and png/gif survey plots and png/gif movie files.
;
; Explanation : Provides wrapper for calls to cep survey plot.
;
; Use         : < cep_survey_wrapper, T0=start_time, T1=end_time >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : CEPPAD level 1 and RAL intermediate format files and postscript and png/gif plots.
;
; Opt. Outputs:	None.
;
; Keywords    : /L1         = Specifies that the l1 files already exist.
;               /RF         = Specifies that the if files already exist.
;                                if STRING or STRARR then assumes file names
;               T0         : STRING giving start time of period of interest in level 1
;                            data. Example format = '10:00:00', ignores day.
;               T1         : STRING giving end   time of period of interest in level 1
;                            data. Example format = '11:00:00', ignores day.
;               TYPE        = INT giving type of survey plot required.
;                                0 : IES/IPS standard plot
;                                1 : HISTE/IES/IPS pitch angle plot
;               /DEBUG      = STOPs in routine.
;               /ALL        = FLAG indicating that all LZ files in specified directory should be processed.
;                                  Avoids use of pickfile.
;               /COPY       = Indicates should copy OR and AT files from CDROM.
;               /FORCE      = forces creation of intermediate files.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 5/11/96
;
; Modified    :	Version 0.1, MKC, 7/11/96
;                 Added start and end time keywords.
;               Version 0.2, MKC, 24/2/97
;                 Added PEDESTAL keyword to cep survey call.
;               Version 0.3, MKC, 21/3/97
;                 Added pedestal call to postscript invocation as well as png/gif.
;               Version 0.4, MKC, 13/5/97
;                 Added png/gif movie file creation.
;                 Added GZIP keyword.
;               Version 0.5, 28/11/97
;                 Used cep_pedestal_plot.
;               Version 0.6, 18/2/98
;                 Used new movie plot format.
;               Version 0.7, 22/10/98
;                 Added BF keyword to cep survey.
;                 Added TYPE keyword. Added REMOVE KEYWORD to cep survey.
;               Version 0.8, 22/12/99
;                 Added DEBUG keyword.
;               Version 0.9, 10/12/00
;                 Added PNG output
;               Version 1.0, 11/06/02
;                 Added version check to select PNG or GIF output.
;               Version 1.1, 20/07/02
;                 Added JAVA plots.
;                 Removed old GIF plots.
;               Version 1.2, 02/10/03
;                 Renamed cep survey.
;                 Removed fix of explicitly setting pedestal environment variable here.
;                 Added /ALL keyword.
;                 Added /COPY keyword.
;               Version 1.3, 21/10/03
;                 Added FORCE keyword.
;
; Version     :	Version 1.3, 21/10/03
;-
;**********************************************************

PRO cep_survey_wrapper, T0=start_time, T1=end_time, L1=l1, RF=rf, TYPE=type, DEBUG=debug, ALL=all, COPY=copy, FORCE=force

  PRINT, 'CREATING POSTSCRIPT SURVEY PLOTS'

  rf_files = cep_survey_plot ( /PS, T0=start_time, T1=end_time, /PEDESTAL, /BF, L1=l1, RF=rf, /GZIP, $
                               TYPE=type, /REMOVE, DEBUG=debug, ALL=all, COPY=copy, FORCE=force)

  ; create pedestal plots

  IF rf_files(0) NE '' THEN dummy = cep_pedestal_plot(rf=rf_files, /PS, DEBUG=debug, /REMOVE, ALL=all, COPY=copy)

  ; create WEB plots

  IF rf_files(0) NE '' THEN cep_survey_nplots,RF=rf_files,NPLOTS=4,/DEBUG,/CHECK,/PEDESTALS,TYPE=[0,3], ALL=all, COPY=copy

  PRINT, 'Processed intermediate format files : '

  FOR k=0, N_ELEMENTS(rf_files)-1 DO PRINT, rf_files[k]

END
