;+
; Project     :	CLUSTER - PEACE
;
; Name        :	CEP_TEMPERATURE_INDEX
;
; Purpose     : Returns index of calibration data temp closest to average for times.
;
; Explanation :	Returns index of calibration data temp closest to average for times.
;
; Use         : < index = cep_temperature_index( times ) >
;
; Inputs      : times : DBLARR(npoints) TAI times of samples.
;
; Opt. Inputs : None.
;
; Outputs     : index : INT specifies temperature index of pedestal data.

;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 02/10/03
;                 Adapted from ies get pedestal histogram
;
; Modified    :
;
; Version     :	Version 0.0, 02/10/03
;-
;**********************************************************

FUNCTION cep_temperature_index, times

  COMMON pedestal_calibration_block, pedestals, temperatures, calibration_file

  ; NB pedestal calibration data must have been set up already

  ; get average temperature for current data

  temperature = cep_get_temperature(times)

  ; get calibration data temp closest to average

  IF temperature EQ -1 THEN index = 0 ELSE dummy = MIN(ABS(temperatures-temperature), index)

  ; return index into pedestal histogram data

  RETURN, index

END