;+
; Project     :	POLAR - CEPPAD
;
; Name        :	GET_CHSIZE
;
; Purpose     :	Return character size in normal coords or character scaling.
;
; Explanation :	Return character size in normal coords or character scaling.
;
; Use         : < get_ysize >
;
; Inputs      : None.    
;
; Opt. Inputs : None.
;
; Outputs     : Return character size in normal coords or character scaling.
;
; Opt. Outputs:	None.
;
; Keywords    : None.       
;
; Calls       :	get_xsize, get_ysize.
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 21/10/96
;               Adapted from ies_do_axes.
;
; Modified    :	None.
;
; Version     :	Version 0.0, 21/10/96
;-
;**********************************************************

FUNCTION get_chsize, X=x, Y=y

  ; return character size in normal coords or character scaling
  ; NB this does not take into account the setting of !P.REGION

  ; !P.CHARSIZE is an overall character scaling
  ; get character size in device coords 

  x_chsize = !D.X_CH_SIZE*!P.CHARSIZE
  y_chsize = !D.Y_CH_SIZE*!P.CHARSIZE

  ; get character size in normal coords.

  char  = CONVERT_COORD ( [ 0, x_chsize], [ 0, y_chsize], /DEVICE, /TO_NORMAL)
 
  x_chsize = char(0,1)
  y_chsize = char(1,1)

  IF KEYWORD_SET(x) THEN RETURN, x_chsize ELSE $
  IF KEYWORD_SET(y) THEN RETURN, y_chsize ELSE $
                         RETURN, 0

END 

