;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_BINS_TO_KEV
;
; Purpose     :	Converts energy channels in bins to kev.
;
; Explanation :	Converts energy channels in bins to kev.
;
; Use         : < output_chans = ies_bins_to_kev(energy_cal, ch_positions) >
;
; Inputs      : energy_cal   : FLTARR[] first element is bin to kev conversion factor
;                                    Optional 2nd element is offset
;               ch_positions : energy channel definitions in bins
;
; Opt. Inputs : None.
;
; Outputs     : output_chans : energy channel definitions in keV
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Prev. Hist. :	Adapted from ies docal
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/11/03
;
; Modified    :
;
; Version     :	Version 0.0, 17/11/03
;-
;**********************************************************

FUNCTION ies_bins_to_kev, energy_cal, ch_positions

  ; set up energies in keV of channel boundaries
  ; NB include offset if present
  ; ensure FLOATs

  output_chans = FLOAT(ch_positions)*energy_cal[0]

  IF N_ELEMENTS(energy_cal) GT 1 THEN output_chans = output_chans + energy_cal[1]

  RETURN, output_chans

END
