;+
; Project     :	POLAR - CEPPAD
;
; Name        :	IES_CHARSIZE
;
; Purpose     :	Adjust character size for widget display.
;
; Explanation :	If characters take up too large a proportion of the vertical display size then makes them smaller.
;
; Use         : < ies_charsize >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : Adjust character size system variable !P.CHARSIZE.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	get_chsize.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 21/10/96
;               Adapted from ies_do_axes.
;
; Modified    :	None.
;
; Version     :	Version 0.0, 21/10/96
;-
;**********************************************************

PRO ies_charsize

  ; fixes character scaling

  ; get y character size

  y_chsize = get_chsize(/Y)

  ; get y_size in normal coords

  y_size  = !P.REGION(3) - !P.REGION(1)

  ; allow y borders around plot window a nominal 4 and 2 characters width
  ; if y borders account for more than 50% then reduce character size

  IF 6*y_chsize GT y_size/2 THEN !P.CHARSIZE = y_size/(12.0 * y_chsize)

END

