;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_COLOR_SCALE
;
; Purpose     :	Performs color scaling.
;
; Explanation : Performs color scaling.
;
; Use         : < ies_color_scale, output_info, array >
;
; Inputs      : None.
;
; Opt. Inputs :             
;
; Outputs     : Displays plots in window.
;
; Opt. Outputs:	
;
; Keywords    : WIDGET  : Flag for widget rather than window output.
;
; Prev. Hist. :	Combined IES_PLOT and IES_WINDOW_PLOT versions.
;
; Written     :	Version 0.0, Martin Carter, RAL, 09/07/02
;
; Modified    :	
;
; Version     :	Version 0.0, 09/07/02
;-
;**********************************************************

PRO ies_color_scale, output_info, array

  ; restrict values

  array = output_info.maximum < array > output_info.minimum

  ; colour scale

  IF output_info.log THEN BEGIN
    array = BYTE ( (ALOG(array)-ALOG(output_info.minimum))*(ies_ncolors()-1) / $
       (ALOG(output_info.maximum)-ALOG(output_info.minimum)) )
  ENDIF ELSE BEGIN
    array = BYTE ( ((array-output_info.minimum)*(ies_ncolors()-1)) / $
       (output_info.maximum-output_info.minimum) )
  ENDELSE

END