;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_CTITLE
;
; Purpose     :	Returns title for counts.
;
; Explanation :	Returns title for counts.
;
; Use         : < ctitle = ies_ctitle( header, output_info) >
;
; Inputs      : header        : STRUCT containing data info.
;               output_info   : STRUCT containing plot info.
;
; Opt. Inputs : None.
;
; Outputs     : ctitle  : STRING data title.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 26/9/96
;                 Adapted from ies text plot.
;
; Modified    :	Version 0.1, MKC, 27/1/99.
;                 Able to run with only header.
;               Version 0.2, MKC, 20/10/00
;                 Allowed header to be undefined.
;
; Version     :	Version 0.2, 20/10/00
;-
;**********************************************************

FUNCTION ies_ctitle, header, output_info

  ; set up flags

  IF N_ELEMENTS(output_info) GT 0 THEN BEGIN
    div = output_info.div
    rat = output_info.rat
    cal = output_info.cal
  ENDIF ELSE BEGIN
    div = header.div
    rat = header.rat
    cal = header.cal
  ENDELSE

  ; define title

  IF KEYWORD_SET(header) THEN ztitle = header.ztitle ELSE ztitle = 'Cts'
  IF rat THEN ztitle = ztitle + '/s'
  IF cal THEN ztitle = ztitle + '/cm2/sr'
  IF div THEN ztitle = ztitle + '/keV'

  RETURN, ztitle

END
