;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_BAND_LABELS
;
; Purpose     :	Sets up band labels.
;
; Explanation :	Sets up band labels.
;
; Use         : < band_labels = ies_band_labels (header, output_info, output_chans) >
;
; Inputs      : header        = structure containing extracted data header information
;               output_info   = structure containing plotting and processing info
;               output_chans  = array containing processed channel positions
;
; Opt. Inputs : None.
;
; Outputs     : output_array  : FLTARR(nsectors, ndetectors, nbands, npoints) containing processed data.
;
; Opt. Outputs:	None.
;
; Keywords    : REVERSE : flag indicating conversion back to counts required.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 26/9/96
;                 Adapted from ies_calibrate.
;
; Modified    :	Version 0.1, 31/8/00
;                 Removed 'Detector' from DETECTOR vs SECTOR band_labels.
;
; Version     :	Version 0.1, 31/8/00
;-
;**********************************************************

FUNCTION ies_band_labels, header, output_info, output_chans

  IF output_info.format EQ 'ENERGY vs DETECTOR' THEN BEGIN  ; NB format for ANGLE/ANGLE

    ; set band labels

    IF output_info.button_values[0] THEN BEGIN

      ctop = (N_ELEMENTS(output_chans[0,*,0,0]) < N_ELEMENTS(output_info.band_labels)) - 1

      band_labels = STRTRIM(STRING(FORMAT='(I)',output_chans(0,0:ctop,0,0)),2) + ':' +$
                    STRTRIM(STRING(FORMAT='(I)',output_chans(1,0:ctop,0,0)),2) + ' keV'

    ENDIF ELSE BEGIN

      band_labels = output_info.band_labels

    ENDELSE

  ENDIF ELSE IF output_info.format EQ 'ENERGY vs SECTOR' THEN BEGIN

    ; set band labels

    IF output_info.button_values[0] THEN BEGIN

      ctop = (N_ELEMENTS(output_chans[0,*,0,0]) < N_ELEMENTS(output_info.band_labels)) - 1

      band_labels = STRTRIM(STRING(FORMAT='(I)',output_chans(0,0:ctop,0,0)),2) + ':' +$
                    STRTRIM(STRING(FORMAT='(I)',output_chans(1,0:ctop,0,0)),2) + ' keV'

    ENDIF ELSE BEGIN

      band_labels = output_info.band_labels

    ENDELSE

  ENDIF ELSE IF output_info.format EQ 'SECTOR vs DETECTOR' THEN BEGIN  ; NB format for TIMELINE

    band_labels = 'Sector '+STRTRIM(INDGEN(header.nsectors),1)

  ENDIF ELSE IF output_info.format EQ 'DETECTOR vs SECTOR' THEN BEGIN

    band_labels = header.ptitle

  ENDIF ELSE IF output_info.format EQ 'PITCH ANGLE vs ENERGY' THEN BEGIN

    band_labels = 'Bin '+STRTRIM(INDGEN(16))

  ENDIF

  RETURN, band_labels

END
