;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_DO_FLAGS
;
; Purpose     :	Does plot of data quality flags.
;
; Explanation :	Uses region above plot to display info.
;
; Use         : < ies_do_flags, x, luts, flags >
;
; Inputs      : x       : FLTARR(npoints) time for each sample
;               luts    : INTARR(npoints) look up table giving energy bins for each sample
;               flags   : BYTARR(npoints) data quality flag for each sample
;
; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 2/6/95
;
; Modified    :	Version 0.1, MKC, 18/9/96.
;                 Added bad lut flag.
;                 Added major frame flag.
;                 Adjusted flag display positions.
;                 Saved plot window.
;               Version 0.2, MKC, 10/5/00
;                 Added flag bits 1 and 2,
;               Version 0.3, 09/07/02
;                 Removed ncolors from argument list.
;
; Version     :	Version 0.3, 09/07/02
;-
;**********************************************************


PRO ies_do_flags, x, luts, flags

  ; draw flags

  ; save plot window and axis range

  plot_window = !P.POSITION
  axis_crange = !X.CRANGE

  ; use the space above the plot window

  !P.POSITION(1) = !P.POSITION(3)
  !P.POSITION(3) = !P.REGION(3)

  ; plot LUT flags in data coords, suppress x and y axes

  PLOT, x, 3*(luts MOD 4), XRANGE=!X.CRANGE, YRANGE=[0,11], XSTYLE=5, YSTYLE=5, /NOERASE, /NOCLIP

  ; plot error flags in data coords

  ; major frame

  list = WHERE ( flags AND '01'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(0,count), COLOR=ies_get_color(0), PSYM=3, /NOCLIP

  ; NM/BM data

  list = WHERE ( flags AND '02'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(0,count), COLOR=ies_get_color(1), PSYM=3, /NOCLIP

  ; normal/abnormal data

  list = WHERE ( flags AND '04'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(0,count), COLOR=ies_get_color(1), PSYM=2, /NOCLIP

  ; bad times (+)

  list = WHERE ( flags AND '40'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(2,count), COLOR=ies_get_color(0), PSYM=1, /NOCLIP

  ; bad counts (*)

  list = WHERE ( flags AND '20'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(4,count), COLOR=ies_get_color(0), PSYM=2, /NOCLIP

  ; bad luts (triangle)

  list = WHERE ( flags AND '10'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(6,count), COLOR=ies_get_color(0), PSYM=5, /NOCLIP

  ; end of data set

  list = WHERE ( flags AND '80'X, count )

  IF count GT 0 THEN OPLOT, x(list), REPLICATE(8,count), COLOR=ies_get_color(0), PSYM=4, /NOCLIP

 ; restore plot window

 !P.POSITION = plot_window
 !X.CRANGE   = axis_crange

END

