;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_DO_LABELS
;
; Purpose     :	Plots energy labels.
;
; Explanation :
;
; Use         : < ies_do_labels, novers, band_labels, TITLE=title, CTITLE=ctitle, NO_XAXIS=no_xaxis >
;
; Inputs      :
;
; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    :
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 2/6/95
;
; Modified    :	Version 0.1, MKC, 29/10/96
;                 Added plot title.
;               Version 0.2, 3/3/97
;                 Modified y title size
;                 Stopped too many labels.
;               Version 0.3, 09/07/02
;                 Removed ncolors from argument list.
;               Version 0.4, 10/02/03
;                 Corrected bug where CTITLE had to be defined..
;
; Version     :	Version 0.3, 09/07/02
;-
;**********************************************************

PRO ies_do_labels, novers, band_labels, TITLE=title, CTITLE=ctitle, NO_XAXIS=no_xaxis

  ; ensure sufficient band labels

  nlabs = novers < N_ELEMENTS(band_labels)

  ; draw band labels

  ; save plot window and axis range

  plot_window = !P.POSITION
  axis_crange = !X.CRANGE

  ; get chararacter sizes

  x_chsize = get_chsize( /X )
  y_chsize = get_chsize( /Y )

  ; leave room for plot title if necessary

  IF N_ELEMENTS(title) GT 0 THEN BEGIN

    ch_factor = 1.5

    ch_factor = ch_factor/((1.1*ch_factor*STRLEN(title)*x_chsize/(!P.REGION(2)-!P.POSITION(2))) > 1.0)

    !P.POSITION(3) = !P.POSITION(3) - 1.67*y_chsize*ch_factor

    XYOUTS, (2*x_chsize+!P.POSITION(2)+!P.REGION(2) - STRLEN(title)*ch_factor*x_chsize)/2.0, !P.POSITION(3)+y_chsize, title, /NORMAL, $
             CHARSIZE=ch_factor*!P.CHARSIZE

  ENDIF

  ; write out label title
  ; NB use !p.region here rather than position to give more room

  IF KEYWORD_SET(ctitle) THEN XYOUTS, (!P.POSITION(2)+!P.REGION(2) - STRLEN(ctitle)*x_chsize)/2.0, !P.POSITION(3)-y_chsize, ctitle, /NORMAL, CHARSIZE=!P.CHARSIZE

  ; a space has been left to the left of the plot window
  ; reset plot window to point at this space
  ; adjust plot window by no. of characters

  !P.POSITION(0) = !P.POSITION(2) + 1*x_chsize
  !P.POSITION(2) = !P.REGION(2) - 1*x_chsize

  ; set output positions for band labels centred in plot window in normal coords

  ; get max band label length, add 3 for line

  max_length = 3 + MAX ( STRLEN ( band_labels(0:nlabs-1) ) )

  ; center labels

  xp = (!P.POSITION(0) + !P.POSITION(2))/2.0 - max_length*x_chsize/2.0
  yp = !P.POSITION(3) - 3*y_chsize

  ; loop over overlays

  FOR k = 0, nlabs-1 DO BEGIN

    ; check if too many overlays to mention

    IF yp-2*y_chsize+y_chsize/4.0 GT !P.POSITION(1) THEN BEGIN

      ; plot labels

      PLOTS, [xp, xp+2*x_chsize], [yp, yp], /NORMAL, COLOR=ies_get_color(k)
      XYOUTS, xp+3.0*x_chsize, yp-y_chsize/4.0, band_labels(k), COLOR=ies_get_color(k), /NORMAL, CHARSIZE=!P.CHARSIZE

      ; adjust yp

      yp = yp - 2*y_chsize

    ENDIF ELSE BEGIN

      XYOUTS, xp+3.0*x_chsize, yp-y_chsize/4.0, '...', /NORMAL, CHARSIZE=!P.CHARSIZE

    ENDELSE

  ENDFOR

 ; restore plot window

 !P.POSITION = plot_window

 !X.CRANGE   = axis_crange

END
