;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_DO_LOGO
;
; Purpose     :	Draws Logo.
;
; Explanation : Draws Logo.
;
; Use         : <  >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : LOGO : INT logo position.
;
; Written     :	Version 0.0, Martin Carter, RAL, 28/03/03
;
; Modified    : Version 0.1, 11/04/03
;                 Corrected bug with logo_pos variable not defined.
;               Version 0.2, 15/07/03
;                 Corrected naming bugs.
;
; Version     :	Version 0.2, 15/07/03
;-
;**********************************************************

PRO ies_do_logo, LOGO=logo

  IF NOT KEYWORD_SET(logo) THEN RETURN

  ; get logo

  logo_image = ies_logo()

  ; draw image in plot box, check if rescaleable output device

  IF !D.FLAGS AND 1 THEN BEGIN

    ; get character sizes in normal coords

    x_chsize = get_chsize(/X)
    y_chsize = get_chsize(/Y)

    ; do logo

    CASE logo OF
      1 : TV, logo_image, 0.0, 1-0.078, XSIZE=0.1, YSIZE=0.078, /NORMAL
      2 : TV, logo_image, 0.9, 1-0.078, XSIZE=0.1, YSIZE=0.078, /NORMAL
      3 : TV, logo_image, 0.0, y_chsize*0.7, XSIZE=0.1, YSIZE=0.078, /NORMAL
      4 : TV, logo_image, 0.9, y_chsize*0.7, XSIZE=0.1, YSIZE=0.078, /NORMAL
      ELSE : ; no logo
    ENDCASE

  ENDIF ELSE BEGIN

    ; do logo

    CASE logo OF
      1 : TV, logo_image, 0, !D.Y_SIZE-(SIZE(logo_image))[2]
      2 : TV, logo_image, !D.X_SIZE-(SIZE(logo_image))[1], !D.Y_SIZE-(SIZE(logo_image))[2]
      3 : TV, logo_image, 0, !D.X_CH_SIZE
      4 : TV, logo_image, !D.X_SIZE-(SIZE(logo_image))[1], !D.X_CH_SIZE
      ELSE : ; no logo
    ENDCASE

  ENDELSE

END
