;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_DO_PRELIMS
;
; Purpose     :	Sets up some common block values used in IES_PLOT and calls DATA SELECT TOOL.
;
; Explanation : Sets up some common block values used in IES_PLOT and calls DATA SELECT TOOL.
;               If ies_calibrate can change the values then they should be set up there.
;
; Use         : < quit =  ies_do_prelims ( MINIMUM=input_minimum, MAXIMUM=input_maximum ) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : Sets up common block values.
;               Returns flag indicating whether to quit or not.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	ies_getset, ies_calibrate, anytim2cal.
;
; Common      :	ies_draw_widget_block.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    : Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/1/96
;
; Modified    :	Version 0.1, MKC, 19/9/96.
;                 Added SECTOR vs DETECTOR option.
;                 Added interpolate button.
;                 Changed SHRINK to CLEAN.
;                 Extended ies_draw_widget_block.
;                 Removed SHIFT button from ANGLE/ANGLE plot.
;                 Moved setting of noutputs and ptitle to ies_calibrate.
;                 Removed CENT button.
;                 Added TIMELINE plot.
;                 Added TRACK.
;               Version 0.2, 16/1/97
;                 Renamed output_info.clean tag to .shift.
;               Version 0.3, 16/1/97
;                 Prevented shift or subtract if pedestal data not present.
;                 Added PROFILES routine.
;                 Added AXES button.
;                 Fixed problem : because TIMELINE uses spectral plot it cannot use the same buttons as
;                 SPECTRAL without causing confusion -- extended buttons to 6 to cope with this.
;                 Added rng to output_info.
;                 Added full_only to output_info.
;                 Added no bad data plot.
;               Version 0.4, 1/4/97
;                 Added button to SPECTRAL plot.
;               Version 0.5, 15/4/97
;                 Allowed CAL, DIV and RAT always.
;               Version 0.6, 30/6/97
;                 Changed initialization of button labels.
;               Version 0.7, 22/8/97
;                 Removed LUT MAP test.
;                 Added elo, ehi tags.
;               Version 0.8, 2/3/98
;                 Removed interpolation option.
;               Version 0.9, 7/10/98
;                 Added Magnetic field and attitude arrays to common block.
;                 Added Sinusoidal projection button to ANGLE/ANGLE and TIMELINE plots.
;               Version 1.0, 11/11/98
;                 Modified button values for LINEPLOT.
;                 Extended output_info.buttons
;               Version 1.1 01/02/99
;                 Removed some options if data required unavailable.
;               Version 1.2 22/02/99
;                 Added output_info tags.
;                 Removed input_minimum and input_maximum.
;               Version 1.3 20/8/00
;                 Increased no. of detectors allowed.
;               Version 1.4 30/8/00
;                 Increased no of band_labels allowed to cope with histpgram mode.
;               Version 1.5 12/03/02
;                 Added extra TIMELINE button
;               Version 1.6 08/05/02
;                 Moved output_info set up to ies_getset.
;                 Added NO BAD to TIMELINE and ANGLEANGLE
;               Version 1.7 12/07/02
;                 Used ies_tag_exists.
;               Version 1.8, 04/02/03
;                 Added MVALS.
;                 Added OVERLAY plot.
;               Version 1.9, 29/09/03
;                 Added npitchs to output_info.
;
; Version     :	Version 1.9, 29/09/03
;-
;**********************************************************

FUNCTION ies_do_prelims

   ; define common blocks used internally for draw widgets
   ; full_header   = structure containing original data header information
   ; full_data     = structure array containing original data
   ; header        = structure containing extracted data header information
   ; data          = structure array containing extracted data
   ; output_info   = structure containing plotting and processing info
   ;     .log           = button value for log display
   ;     .cal           = button value for calibrated display
   ;     .div           = button value for bin divided display
   ;     .shift         = button value for resampled and shifted display
   ;     .subtract      = button subtract pedestal from data
   ;     .track         = indicates tracking required
   ;     .rng           = FLT time range in secs for PROFILES procedure
   ;     .npitchs       = INT no of pitch angle bins
   ;     .button_labels = STRARR(12) for button labels
   ;     .button_values = LONARR(12) for button values
   ;     .procname      = STRING name of procedure used for drawing in window
   ;     .full_only     = flag indicating only full display
   ;     .full_detector = LONG giving detector for full display
   ;     .full_sector   = LONG giving sector for full display (defaults to 0 for now)
   ;     .axes          = indicates extra axes required
   ;     .band_labels   = STRARR(20) labels for each plot type within window (ie. energy bands)
   ;     .noutputs      = INT no. of displays (i.e ndetectors).
   ;     .format        = STRING format for display.
   ;     .ptitle        = STRARR(20) labels for each window (i.e detector no.s)
   ;     .time          = DOUBLE tai time for current cursor position.
   ;     .ysamples      = INT no. of samples on y axis (i.e nbands).
   ;     .minimum       = minimum data value
   ;     .maximum       = maximum data value
   ;     .elow          = FLOAT min energy axis display value
   ;     .ehigh         = FLOAT max energy axis display value
   ;     .emin          = flag indicating that minimum should be used
   ;     .emax          = flag indicating that maxnimum should be used
   ;     .elo           = flag indicating that elow should be used
   ;     .ehi           = flag indicating that ehigh should be used
   ; output_chans  = array containing processed channel positions
   ; output_array  = array containing processed data for plotting
   ; ids           = structure giving widget IDs
   ; dnfull        = co-ordinate conversion array for full window
   ; dnscroll      = co-ordinate conversion array for magnified windows
   ; files         = STRARR giving data file names
   ; ephem         = structure containing ephemeris data
   ; mf            = structure containing magnetic field data
   ; at            = structure containing attitude data

   COMMON ies_draw_widget_block, full_header, full_data, header, data, output_info, output_chans, output_array, $
                                 ids, dnfull, dnscroll, files, ephem, mf, at

START :

   ; check if quit

   IF ies_getset () THEN RETURN, 1

   ; set up common block values

   ; get copy of axis

;   IF KEYWORD_SET(input_axis) THEN axis=input_axis(st.sttime:st.entime)

   ; get calendar day corresponding to midpoint

   midday = anytim2cal ( (header.tstart+header.tstop)/2, FORM = 9, /DATE)

   ; set up user button labels

   IF output_info.procname EQ 'SPECTRAL' THEN BEGIN

     IF output_info.button_labels(0) NE 'BINS'   THEN output_info.button_values(0) = 1
     IF output_info.button_labels(2) NE 'NO BAD' THEN output_info.button_values(2) = 0
     IF output_info.button_labels(3) NE 'ELOG'   THEN output_info.button_values(3) = 0

     output_info.button_labels = ['BINS','','NO BAD','ELOG','','','','','','','','']

   ENDIF ELSE IF output_info.procname EQ 'LINEPLOT' THEN BEGIN

     IF output_info.button_labels(0) NE 'BINS'   THEN output_info.button_values(0) = 1
     IF output_info.button_labels(1) NE 'POINTS' THEN output_info.button_values(1) = 0
     IF output_info.button_labels(2) NE 'NO BAD' THEN output_info.button_values(2) = 0
     IF output_info.button_labels(4) NE 'LINES'  THEN output_info.button_values(4) = 1

     output_info.button_labels = ['BINS', 'POINTS','NO BAD','','LINES','','','','','','','']

   ENDIF ELSE IF output_info.procname EQ 'PROFILES' THEN BEGIN

     IF output_info.button_labels(0) NE 'BINS'   THEN output_info.button_values(0) = 0
     IF output_info.button_labels(2) NE 'NO BAD' THEN output_info.button_values(2) = 0
     IF output_info.button_labels(3) NE 'ELOG'   THEN output_info.button_values(3) = 0

     output_info.button_labels = ['BINS','','NO BAD','ELOG','','','','','','','','']

   ENDIF ELSE IF output_info.procname EQ 'OVERLAY' THEN BEGIN

     IF output_info.button_labels(0) NE 'BINS'   THEN output_info.button_values(0) = 0
     IF output_info.button_labels(2) NE 'NO BAD' THEN output_info.button_values(2) = 0
     IF output_info.button_labels(3) NE 'ELOG'   THEN output_info.button_values(3) = 0

     output_info.button_labels = ['BINS','','NO BAD','ELOG','','','','','','','','']

   ENDIF ELSE IF output_info.procname EQ 'ANGLE/ANGLE' THEN BEGIN

     IF output_info.button_labels(0) NE 'BINS'   THEN output_info.button_values(0) = 0
     IF output_info.button_labels(2) NE 'NO BAD' THEN output_info.button_values(2) = 0
     IF output_info.button_labels(4) NE 'MVALS'  THEN output_info.button_values(4) = 1
     IF output_info.button_labels(5) NE 'MASK'   THEN output_info.button_values(5) = 0
     IF output_info.button_labels(6) NE 'PROJ'   THEN output_info.button_values(6) = 0

     output_info.button_labels = ['BINS','','NO BAD','','MVALS','MASK','PROJ','','','','','']

     ; remove buttons if data not available

     IF NOT ies_tag_exists(data,'EARTH') OR NOT ies_tag_exists(data,'SUN') THEN BEGIN
        output_info.button_labels(5) = ''
        output_info.button_values(5) = 0
     ENDIF

     IF NOT ies_tag_exists(data,'MF') THEN BEGIN
       output_info.button_labels(6) = ''
       output_info.button_values(6) = 0
     ENDIF

     IF NOT ies_tag_exists(data,'MVALS') THEN BEGIN
       output_info.button_labels(4) = ''
       output_info.button_values(4) = 0
     ENDIF

   ENDIF ELSE IF output_info.procname EQ 'TIMELINE' THEN BEGIN

     IF output_info.button_labels(0) NE 'BINS'   THEN output_info.button_values(0) = 0
     IF output_info.button_labels(2) NE 'NO BAD' THEN output_info.button_values(2) = 0
     IF output_info.button_labels(4) NE 'MVALS'  THEN output_info.button_values(4) = 1
     IF output_info.button_labels(5) NE 'MASK'   THEN output_info.button_values(5) = 0
     IF output_info.button_labels(6) NE 'PROJ'   THEN output_info.button_values(6) = 0

     output_info.button_labels = ['BINS','','NO BAD','','MVALS','MASK','PROJ','/1','/2','/4','/8','/16']

     ; set exlusive buttons

     output_info.button_values[7:11] = 0

     ; remove buttons if data not available

     IF NOT ies_tag_exists(data,'EARTH') OR NOT ies_tag_exists(data,'SUN') THEN BEGIN
        output_info.button_labels(5) = ''
        output_info.button_values(5) = 0
     ENDIF

     IF NOT ies_tag_exists(data,'MF') THEN BEGIN
       output_info.button_labels(6) = ''
       output_info.button_values(6) = 0
     ENDIF

     IF NOT ies_tag_exists(data,'MVALS') THEN BEGIN
       output_info.button_labels(4) = ''
       output_info.button_values(4) = 0
     ENDIF

   ENDIF

   ; set up shift and subtract buttons to prevent processing being applied twice

   IF header.clean NE 0 THEN output_info.shift = 0
   IF header.subtract NE 0 THEN output_info.subtract = 0

   ; process data

   IF ies_calibrate() THEN GOTO, START

   ; completed OK

   RETURN, 0

END
