;+
; Project     :	CLUSTER - RAPID, POLAR _ CEPPAD
;
; Name        :	IES_DO_XCOLORBAR
;
; Purpose     :	Draws color bar.
;
; Explanation :	Draws color bar.
;
; Use         : < ies_do_xcolorbar, ymin, ymax, CTITLE=ctitle, NO_XAXIS=no_xaxis, LOG=log >
;
; Inputs      : 
;
; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    : CTITLE      : Title for colorbar.
;
; Calls       :	None..
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 2/6/95
;
; Modified    :	Version 0.1, 29/10/96
;                 Added plot title.
;               Version 0.2, 26/1/99
;                 Changed use of XLOG keyword in AXIS.
;                 NB Previously did not subtract minimum if linear plot. 
;                 This does not conform to use of ies_do_xcolorbar.
;               Version 0.3, 09/07/02
;                 Removed ncolors from argument list.
;
; Version     :	Version 0.3, 09/07/02
;-
;**********************************************************

PRO ies_do_xcolorbar, xmin, xmax, CTITLE=ctitle, LOG=log

  ; draw x axis color bar

  ; set plot axes in device coords, suppress x and y axes

  PLOT, [0,1], /NODATA, XSTYLE=4, YSTYLE=4, /NOERASE

  ; write out colorbar 

  ; draw x axis

  AXIS, XLOG=log, XAXIS=0, XRANGE=[xmin,xmax], YTICKLEN=-0.02, XSTYLE=1, XTITLE=ctitle, $
          CHARSIZE=!P.CHARSIZE

  ; get device coords of plot window

  vector = CONVERT_COORD ( !X.WINDOW, !Y.WINDOW, /NORMAL, /TO_DEVICE )

  ; get origin and size in device co-ords (inclusive)

  xorig = vector(0,0)
  yorig = vector(1,0)
  xsize = vector(0,1) - xorig + 1
  ysize = vector(1,1) - yorig + 1

  ; plot array, checking if scaleable output
  ; NB must be after plot if plot erases

  IF !D.FLAGS AND 1 THEN $
    TV, FINDGEN(ies_ncolors(),1), xorig, yorig, XSIZE=xsize, YSIZE=ysize, /DEVICE, ORDER=0 $
  ELSE $
    TV, FINDGEN(xsize)#REPLICATE(1,ysize)*ies_ncolors() /FLOAT(xsize), xorig, yorig, ORDER=0

  ; overplot axes again to neaten up
  ; NB use dont use data coords because x axis extended in data coords
  ; NB dont want to use plot again because of multiple plots

  PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
         [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

END

