;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_DOCAL
;
; Purpose     :	Applies various corrections to data.
;
; Explanation :	Calculates pedestal positions and subtracts pedestal from data.
;               Applies pedestal offset correction and resamples data.
;
; Use         : < ies_docal, header, data, output_array, output_chans, nbands, output_info >
;
; Inputs      : header      : intermediate format header structure.
;               data        : uncalibrated intermediate format data structure array.
;               output_info : structure containing plotting and processing info
;
; Opt. Inputs : None.
;
; Outputs     : output_array : calibrated data
;               output_chans : energy channel definitions in keV
;               nbands       : no. of energy channels
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Prev. Hist. :	Adapted from ies_calibration.
;
; Written     :	Version 0.0, Martin Carter, RAL, 15/11/96
;
; Modified    :	Version 0.1, 16/1/97.
;                 Changed to a procedure.
;                 Added new pedestal subtraction.
;                 Added pedestal shift routine.
;               Version 0.2, 16/1/97.
;                 Changed .ndetectors tag.
;                 Added pedestal shift to ies pedestals.
;               Version 0.3, 11/3/97.
;                 Changed pedestal_shift to pedestal_info.
;               Version 0.4, 15/4/97.
;                 Added output_info to argument list and removed KEYWORDs.
;               Version 0.5, 18/8/97.
;                 Added energy efficiency.
;                 Changed ies pedestals argument list.
;               Version 0.6, 10/10/97
;                 Added energy_calibration offset.
;               Version 0.7, 25/2/98
;                 Made 10 th channel an integral channel.
;                 Changed so that ies shift works in bins rather than keV.
;                 Changed so that ies shift does not update nbands.
;               Version 0.8, 28/10/98
;                 Changed so that if rates then converts to counts per sector.
;               Version 0.9, 7/9/00
;                 Fixed bug where header.nbands was used instead of bands -- this causes problems
;                 if shift used.
;                 Force use of CENTROID algorithm for RAPID data
;               Version 1.0, 20/9/00
;                 Moved set up of pedestal calibration data to here.
;                 Added RAPID keyword to ies pedestals.
;               Version 1.1, 13/10/00
;                 Passed lut map in ies pedestals argument list instead of picking up from calibration file.
;               Version 1.2, 08/05/01
;                 Added ENDTIMES keyword to ies_rat.
;               Version 1.3 12/07/02
;                 Used ies_tag_exists.
;               Version 1.4 08/02/03
;                 Ensured output_chans is a float array.
;               Version 1.5 14/04/03
;                 Changed argument list of ies_rat.
;               Version 1.6, 26/09/03
;                 Used new routine for instrument test.
;                 Check do not use ies pedestals for RAPID data.
;                 Changed argument list of ies get pedestal calibration
;                 Renamed routine ies pedestals.
;                 Used ies get dir.
;               Version 1.7, 24/10/03
;                 Used ies lut list.
;               Version 1.8, 14/11/03
;                 Used ies_bins_to_kev.
;               Version 1.9, 20/11/03
;                 Separated routine ies docal into ies do clean and ies do cal.
;
; Version     :	Version 1.9, 20/11/03
;-
;**********************************************************

PRO ies_docal, header, data, output_array, output_chans, nbands, output_info

  ; initializations

  nbands = header.nbands

  output_array = REFORM ( data.data, header.nsectors, header.ndetectors, nbands, header.npoints)

  ; set up  energies in keV of channel boundaries
  ; NB include offset if present

  output_chans = ies_bins_to_kev(header.energy_cal, header.ch_positions)

  ; get list of lut runs

  lut_list = ies_lut_list(data.lut, header.nluts )

  ; correct data
  ; may update nbands, output_chans, output_array

  ies_do_clean, lut_list, header, data, output_array, output_chans, nbands, output_info

  ; calibrate data

  ies_do_cal, lut_list, header, data, output_array, output_chans, nbands, output_info

END
