;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_DRAW_PEDESTAL
;
; Purpose     :	Does plot of pedestal shifts.
;
; Explanation :	Does not assume that data is evenly sampled in time.
;
; Use         : < ies_draw_pedestal, x, y, xmargin, ymargin, ncolors, YRANGE=yrange, YTITLE=ytitle, /NO_XAXIS, _EXTRA=extra >
;
; Inputs      : x            : DBLARR(npoints) times for each sample in TAI format
;               y            : FLTARR(npoints,nsectors,ndetectors) data values at each sample point 
;               xmargin      : INTARR(2) character size of left and right margins.           
;               ymargin      : INTARR(2) character size of top and bottom margins.    
;
; Opt. Inputs : None.
;
; Outputs     : Draws plot on current graphics device.
;
; Opt. Outputs:	None.
;
; Keywords    : /NO_XAXIS   = controls whether x axis displayed.     
;               YRANGE      = FLTARR(2) min and max y values.
;               YTITLE      = STRING y axis title.
;               /_EXTRA     = any plot keywords.     
;
; Calls       :	ies_do_axes.
;                
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 11/2/97
;
; Modified    :	Version 0.1, MKC, 9/10/98
;                 Added ncolors to argument list.
;               Version 0.2, 09/07/02
;                 Removed ncolors from argument list.
;
; Version     :	Version 0.2, 09/07/02
;-
;**********************************************************

PRO ies_draw_pedestal, xt, y, xmargin, ymargin, YRANGE=yrange, NO_XAXIS=no_xaxis, TITLE=title, YTITLE=ytitle, _EXTRA=extra

  ; get dimensions

  npoints = (SIZE(y))(1)
  IF (SIZE(y))(0) GT 1 THEN nsectors = (SIZE(y))(2) ELSE nsectors = 1
  IF (SIZE(y))(0) GT 2 THEN ndetectors = (SIZE(y))(3) ELSE ndetectors = 1

  ; set up time_start and time_end

  time_start = xt(0)
  time_end   = xt(N_ELEMENTS(xt)-1)

  ; set up max and min y values

  IF KEYWORD_SET(yrange) THEN BEGIN
    ylo = yrange(0)
    yhi = yrange(1)
  ENDIF ELSE BEGIN
    ylo = MIN(y)
    yhi = MAX(y)
  ENDELSE

  ; set up ytitle
  
  IF NOT KEYWORD_SET(ytitle) THEN ytitle = 'Shift [bins]'

  ; set up axes
 
  ies_do_axes, time_start, time_end, ylo, yhi, xmargin, ymargin, NO_XAXIS=no_xaxis, $
               /NO_ERASE, XTITLE='Time', YTITLE=ytitle, _EXTRA=extra

  ; remove offset in internal time

  x = xt - xt(0)
             
  ; loop over overlays

  FOR k = 0, nsectors-1 DO BEGIN

    ; plot y for overlay

    OPLOT, x, y( *, k, 0), COLOR=ies_get_color(k)

  ENDFOR

  ; overplot axes again to neaten up
  ; NB use dont use data coords because x axis extended in data coords
  ; NB dont want to use plot again because of multiple plots

  PLOTS, [ !X.WINDOW(0), !X.WINDOW(1), !X.WINDOW(1), !X.WINDOW(0), !X.WINDOW(0)], $
         [ !Y.WINDOW(0), !Y.WINDOW(0), !Y.WINDOW(1), !Y.WINDOW(1), !Y.WINDOW(0)], /NORMAL

  ; plot title 

  IF KEYWORD_SET(title) THEN BEGIN

    ; get character sizes in normal coords

    x_chsize = get_chsize(/X)
    y_chsize = get_chsize(/Y)

    XYOUTS, (!P.POSITION(2)+!P.REGION(2) - STRLEN(title)*x_chsize)/2.0, !P.POSITION(3)-7*y_chsize, title, /NORMAL, CHARSIZE=1.5*!P.CHARSIZE 

  ENDIF

END
