;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_END_PLOT
;
; Purpose     :	Closes down graphics device for plot.
;
; Explanation : Closes down graphics device for plot.
;
; Use         : < ies_end_plot, file >
;
; Inputs      : file    : STRING file name.
;               devname : STRING name of main device i.e 'X' or 'WIN'
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : /WINDOWS    = plots output in x window.
;               /POSTSCRIPT = plots output as postscript file
;                             Assumes string is file name.
;               /PNG        = plots output as PNG file
;                             Assumes string is file name.
;               /GIF        = plots output as GIF file
;                             Assumes string is file name.
;               /BWPS       = plots output as black and white postscript file
;                             Assumes string is file name.
;               /QUIET      = Flag for no printing.
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/9/00
;
; Modified    :	Version 0.1, 16/05/01
;                 Adapted from ies_window_plot.
;               Version 0.2. 04/02/02
;                 Added reset of !p.region and !p.position
;               Version 0.3. 05/07/02
;                 Removed extra printed line after printout.
;               Version 0.4, 13/1/03
;                 Moved gubbins to ies_end_plot_gubbins.
;               Version 0.5, 28/03/03
;                 Removed ies_end_plot_gubbins.
;                 Added QUIET keyword.
;
; Version     :	Version 0.5, 28/03/03
;-
;**********************************************************

PRO ies_end_plot, file, devname, WINDOWS=windows, POSTSCRIPT=postscript, PNG=png, GIF=gif, BWPS=bwps, QUIET=quiet

  ON_IOERROR, IOERROR

  !P.REGION = 0
  !P.POSITION = 0

  ; check for postscript

  IF KEYWORD_SET(postscript) OR KEYWORD_SET(bwps) THEN BEGIN

    DEVICE, /CLOSE

    SET_PLOT, devname

  ENDIF ELSE IF KEYWORD_SET(png) OR KEYWORD_SET(gif) THEN BEGIN

    image = TVRD()

    IF KEYWORD_SET(png) THEN $
      ies_write_png, file, image $
    ELSE $
      ies_write_gif, file, image

    SET_PLOT, devname

  ENDIF

  IF NOT KEYWORD_SET(quiet) THEN PRINT, 'CREATED PLOT IN '+file

  RETURN

IOERROR:

  MESSAGE, !ERR_STRING, /CONT, /TRACEBACK

  SET_PLOT, devname

  RETURN

END
