;+
; Project     :	CLUSTER - POLAR - PULSAUR
;
; Name        :	IES_ENDTIMES
;
; Purpose     :	Gets end times of samples
;
; Explanation : Gets end times of samples
;
; Use         : < times = ies_endtimes(data) >
;
; Inputs      : data    : structure containing input data
;
; Opt. Inputs : None.
;
; Outputs     : times   : DBLARR{] TAI times
;
; Opt. Outputs:	one.
;
; Keywords    : LIST : LONARR[] list of times for which endtimes required
;
; Written     :	Version 0.0, Martin Carter, RAL, 14/04/03
;                 Derived from ies extdata
;
; Modified    :
;
; Version     :	Version 0.0, 14/04/03
;-
;**********************************************************

FUNCTION ies_endtimes, data, LIST=list

  ; check if endtime tag available
  ; if so check endtimes are set

  IF ies_tag_exists(data,'ENDTIME') THEN IF data[0].endtime NE 0.0D0 THEN BEGIN

    IF KEYWORD_SET(list) THEN RETURN, data[list].endtime ELSE RETURN, data.endtime

  ENDIF

  ; use sample start times to generate endtimes

  npoints = N_ELEMENTS(data)

  nlist = N_ELEMENTS(list)

  ; check more than one sample

  IF npoints GT 1 THEN BEGIN

    ; use previous sample duration for last sample duration if needed

    last_sample_time = 2*data[npoints-1].time-data[npoints-2].time

    ; check if list given

    IF KEYWORD_SET(list) THEN BEGIN

      ; check if last sample is needed

      IF list[nlist-1] NE npoints-1 THEN RETURN, data[list+1].time

      ; check more than one item in list

      IF nlist GT 1 THEN RETURN, [data[list[0:nlist-2]+1].time,last_sample_time]

      ; only one item in list and is last sample

      RETURN, [last_sample_time]

    ENDIF

    ; no list given

    RETURN, [data[1:*].time,last_sample_time]

  ENDIF

  ; use default 1 sec duration for only sample
  ; use list to ensure validity

  IF KEYWORD_SET(list) THEN RETURN, data[list].time+1 ELSE RETURN, data.time+1

END