;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_FILE_EXISTS
;
; Purpose     :	Tests if file exists. 
;
; Explanation :	Tests if file exists. 
;
; Use         : < res = ies_file_exists(filename) >
;
; Inputs      : filename      : STRING file name.
;
; Opt. Inputs : None.
;
; Outputs     : res : FLAG 0 : file does not exist
;                          1 : files exists.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utility.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 05/07/02
;
; Modified    :	None.
;
; Version     :	Version 0.0, 05/07/02
;-
;**********************************************************

FUNCTION ies_file_exists, filename

  ; NB if filename is blank then gives files in current directory

  IF filename EQ '' THEN RETURN, 0

  ; doesnt check if file is unique
  ; ie if filename is '*' then finds all files in subdirectories also

  IF (FINDFILE(filename))[0] NE '' THEN RETURN, 1 ELSE RETURN, 0

END
