;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_FIT_PEDESTAL
;
; Purpose     : Returns pedestal position and FWHM from fit to pedestal histogram data.
;
; Explanation :	Returns pedestal position and FWHM from fit to pedestal histogram  data.
;
; Use         : < ies_fit_pedestal, pdata, pedestal_posn, pedestal_width >
;
; Inputs      : pdata          : FLTARR(nbins) pedestal histogram data.
;
; Opt. Inputs : None.
;
; Outputs     : pedestal_posn : FLOAT position of pedestal
;                               NB This is calculated putting data on bin centres.
;               pedestal_width: FLOAT FWHM of pedestal in bins.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	ies_sgausscv.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	Moved from ies get samples.
;
; Written     :	Version 0.0, Martin Carter, RAL, 12/10/00
;
; Modified    :	None.
;
; Version     :	Version 0.0, 12/10/00
;-
;**********************************************************

PRO ies_fit_pedestal, pdata, pedestal_posn, pedestal_width

  ; get no. of pedestal samples

  nbins = N_ELEMENTS(pdata)

  ; fit pedestal histogram data with Gaussian

  max_pdata = MAX(pdata,maxx)

  pdata_slice = pdata((maxx-30)>0:(maxx+30)<(nbins-1))

  a = DOUBLE([max_pdata,30<maxx,2])

  f = CURVEFIT ( 0.5+FINDGEN(N_ELEMENTS(pdata_slice)), DOUBLE(pdata_slice), DOUBLE(1/(pdata_slice>1.)), a, FUNCTION_NAME='ies_sgausscv' )
 ; f = rcs_curvefit( 0.5+FINDGEN(N_ELEMENTS(pdata_slice)), DOUBLE(pdata_slice), DOUBLE(1/(pdata_slice>1.)), a)

  pedestal_posn  = a(1) + ((maxx-30)>0)
  pedestal_width = a(2)

END