;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_GET_COLOR
;
; Purpose     :	Gets prominent colour for display.
;
; Explanation :	Gets a colour corresponding to supplied index.
;
; Use         : < color = ies_get_color(k) >
;
; Inputs      : k            : INT index of color
;
; Opt. Inputs : None.
;
; Outputs     : color : INT color index 0:255
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 09/07/02
;
; Modified    : 
;
; Version     :	Version 0.0, 09/07/02
;-
;**********************************************************

FUNCTION ies_get_color, k

  ; set up colors to be used
  ; change white to black if postscript

  IF !D.NAME EQ 'PS' THEN $
    colors = [0,240,150,30,208,192,170,112,96,80,64,48,16] $
  ELSE $
    colors = [256,240,150,30,208,192,170,112,96,80,64,48,16]

  IF k LT N_ELEMENTS(colors) THEN col = colors[k] ELSE col = colors[0]

  col = ((ies_ncolors()-1L)*col)/256

  RETURN, col

END

