;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_GET_DIR
;
; Purpose     :	Gets different directory names.
;
; Explanation :	Gets different directory names.
;
; Use         : < dirname = ies_get_dir(/IES) >
;
; Inputs      : type     : STRING environment variable type
;                            IF    : return IF    directory
;                            IES   : return IES   directory.
;                            IPS   : return IPS   directory.
;                            HISTe : return HISTE directory.
;                            HISTp : return HISTP directory.
;                            HK    : return HK    directory.
;                            MF    : return MF    directory.
;                            PD    : return PED   input directory.
;                            PNG   : return PNG   output directory.
;                            PS    : return PS    output directory.
;                            GIF   : return GIF   output directory.
;                            ALL   : return IES,IPS,HISTE,HISTP,HK directories.
;                            etc
;
;
; Opt. Inputs : None.
;
; Outputs     : dirname  : STRING directory name.
;
; Opt. Outputs: None.
;
; Keywords    : /POLAR      = FLAG use POLAR
;               /RAPID      = FLAG use RAPID
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 8/4/98
;
; Modified    : Version 0.1, 14/9/98, MKC
;                 Removed RF keyword option. Set default directory to current directory.
;               Version 0.2, 22/10/98, MKC
;                 Added BF keyword.
;               Version 0.3, 3/9/00
;                 Added RAPID keyword.
;               Version 0.4, 02/10/03
;                 Removed pedout since not IF directory.
;                 Renamed pedin to ped.
;               Version 0.5, 08/10/03
;                 Changed IF directory environment variable name.
;                 Changed keyword arguments to type argument and added POLAR and RAPID keywords.
;               Version 0.6, 21/10/03
;                 Added default directories.
;
; Version     :	Version 0.6, 21/10/03
;-
;**********************************************************

FUNCTION ies_get_dir, type, POLAR=polar, RAPID=rapid

  ; check if RAPID or POLAR

  IF KEYWORD_SET(polar) THEN BEGIN

    IF type EQ 'ALL' THEN $
      RETURN, [GETENV('PO_CEP_IES_DIR'),GETENV('PO_CEP_IPS_DIR'),GETENV('PO_CEP_HISTe_DIR'),$
               GETENV('PO_CEP_HISTp_DIR'),GETENV('PO_CEP_HK_DIR'),GETENV('PO_CEP_MF_DIR')]

    dir = GETENV ( 'PO_CEP_'+type+'_DIR' )

    IF NOT KEYWORD_SET(dir) THEN dir = GETENV ( 'PO_CEP_DEFAULT_'+type+'_DIR' )

    RETURN, dir

  ENDIF ELSE IF KEYWORD_SET(rapid) THEN BEGIN

    RETURN, GETENV ( 'RCS_'+type+'_DIRECTORY' )

  ENDIF ELSE BEGIN

    MESSAGE, 'IMPLEMENTATION ERROR', /TRACEBACK

    RETURN, ''

  ENDELSE

END
