;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_GET_FILE_EXTENSION
;
; Purpose     :	Gets file extension string.
;
; Explanation : Gets file extension string.
;
; Use         : < extension = ies_get_file_extension(filename) >
;
; Inputs      : filename : STRING file name
;
; Opt. Inputs : None.
;
; Outputs     : extension : STRING file extension
;
; Opt. Outputs:	None.
;
; Keywords    : POS : INT position of '.' ie length of root
;
; Written     :	Version 0.0, Martin Carter, RAL, 17/07/03
;
; Modified    : Version 0.1, 31/07/03
;                 Corected bug : variable file not defined.
;
; Version     :	Version 0.0, 17/07/03
;-
;**********************************************************

FUNCTION ies_get_file_extension, filename, POS=pos

  ; get position of last '.'

  pos = STRPOS(filename,'.',/REVERSE_SEARCH, /REVERSE_OFFSET)

  ; check file name does not end with a '.'

  IF pos EQ STRLEN(filename)-1 THEN extension = '' ELSE extension = STRMID(filename,pos+1)

  RETURN, extension

END
