;+
; Project     :	CLUSTER - RAPID, POLAR _ CEPPAD
;
; Name        :	IES_GET_HILO
;
; Purpose     :	Finds hi and lo energies for plotting.
;
; Explanation :	Sets hi and lo values. If sensitive then uses value else uses output_chans.
;               Displays values used.
;
; Use         : < ies_get_hilo, output_chans, eloid, ehiid, output_info >
;
; Inputs      : output_chans : FLTARR channel boundary positions
;               eloid  : LONG widget ID for lo display.
;               ehiid  : LONG widget ID for hi display.
;
; Opt. Inputs : None.
;
; Outputs     : output_info : Output structure
;                             Sets :
;                               elo : flag
;                               ehi : flag
;                               elow : FLOAT lo data value.
;                               ehigh : FLOAT hi data value.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 22/2/99
;
; Modified    :	Version 0.1, MKC, 17/3/99
;                 Added output_info
;               Version 0.2, MKC, 24/5/00
;                 Changed behaviour on setting elow to 0 if not showch
;
; Version     :	Version 0.1, 17/3/99
;-
;**********************************************************


PRO ies_get_hilo, output_chans, eloid, ehiid, output_info, SHOWCH=showch, ELOG=elog

  ; read hi and lo

  IF WIDGET_INFO(eloid, /VALID_ID) THEN BEGIN
    IF WIDGET_INFO(eloid, /TEXT_EDITABLE) THEN BEGIN
      WIDGET_CONTROL, eloid, GET_VALUE=value
      output_info.elow = FLOAT(value(0))
      output_info.elo = 1
    ENDIF ELSE output_info.elo = 0
  ENDIF

  IF WIDGET_INFO(ehiid, /VALID_ID) THEN BEGIN
    IF WIDGET_INFO(ehiid, /TEXT_EDITABLE) THEN BEGIN
      WIDGET_CONTROL, ehiid, GET_VALUE=value
      output_info.ehigh = FLOAT(value(0))
      output_info.ehi = 1
    ENDIF ELSE output_info.ehi = 0
  ENDIF

  IF KEYWORD_SET(showch) THEN BEGIN

    IF output_info.elo EQ 0 THEN output_info.elow = MIN(output_chans(0,*,*,*))
    IF output_info.ehi EQ 0 THEN output_info.ehigh = MAX(output_chans(1,*,*,*))

    ; IPS integral channel goes down to zero keV
    ; or sector [deg] vs detector plot

    IF KEYWORD_SET(elog) AND output_info.elow LE 0.0 THEN output_info.elow = 1.0

  ENDIF ELSE BEGIN

    IF output_info.elo EQ 0 THEN output_info.elow = 0
    IF output_info.ehi EQ 0 THEN output_info.ehigh = output_info.ysamples

    IF KEYWORD_SET(elog) AND output_info.elow LE 0.0 THEN output_info.elow = 0.5

  ENDELSE

  ; IF lo and hi equal then alter

  IF output_info.elow EQ output_info.ehigh THEN BEGIN

    IF output_info.elow EQ 0 THEN BEGIN
      output_info.elow = 0
      output_info.ehigh = 1
    ENDIF ELSE BEGIN
      output_info.elow = output_info.elow/2
      output_info.ehigh = output_info.ehigh*2
    ENDELSE

  ENDIF

  ; fix hi greater than lo

  IF output_info.ehigh LT output_info.elow THEN BEGIN
    temp = output_info.elow
    output_info.elow = output_info.ehigh
    output_info.ehigh = temp
  ENDIF

  IF WIDGET_INFO(eloid, /VALID_ID) THEN WIDGET_CONTROL, eloid, $
    SET_VALUE=STRTRIM(STRING(FORMAT='(G9.3)',output_info.elow),2)

  IF WIDGET_INFO(ehiid, /VALID_ID) THEN WIDGET_CONTROL, ehiid, $
    SET_VALUE=STRTRIM(STRING(FORMAT='(G9.3)',output_info.ehigh),2)

END

