;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_GET_PEDESTAL_CALIBRATION
;
; Purpose     : Retrieves pedestal calibration data for CEPPAD or RAPID.
;
; Explanation :	Pedestal calibration data is stored in IES_CALIBRATION files.
;               This routine restores the relevant pedestal calibration data provided it has not already
;               been stored and stores in the pedestal calibration data COMMON block.
;
; Use         : < ies_get_pedestal_calibration, file >
;
; Inputs      : file : STRING name of calibration file
;
; Opt. Inputs : None.
;
; Outputs     : None.
;
; Opt. Outputs:	None.
;
; Keywords    : FORCE : FLAG indicating should force set up of calibration data even if already exists.
;
; Calls       :	None.
;
; Common      :	pedestal_calibration_block.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	Adapted from ies get samples.
;
; Written     :	Version 0.0, Martin Carter, RAL, 20/09/00
;
; Modified    :	Version 0.1, 02/10/03
;                 Changed file from keyword to argument to remove POLAR dependence.
;               Version 0.2. 12/12/03
;                 Changed to more explicit logic.
;               Version 0.3, 09/01/04
;                 Added check that calibration file exists.
;                 Set calibration file after restore to avoid common block being set up before restore worked.
;               Version 0.4, 02/02/04
;                 Added FORCE keyword.
;
; Version     :	Version 0.4, 02/02/04
;-
;**********************************************************

PRO ies_get_pedestal_calibration, file, FORCE=force

  ; for POLAR (04/12/03)
  ; pedestals    : FLTARR[9,256, 8, 4]
  ; temperatures : FLTARR[4]

  ; for RAPID (04/12/03)
  ; pedestals    : FLTARR[9,256,4]
  ; temperatures : FLOAT

  COMMON pedestal_calibration_block, pedestals, temperatures, calibration_file

  ; check if already have calibration file

  IF N_ELEMENTS(calibration_file) NE 0 AND NOT KEYWORD_SET(force) THEN BEGIN

    IF calibration_file EQ file THEN RETURN

  ENDIF

  ; check calibration file exists

  IF NOT ies_file_exists(file) THEN rcs_message, 'CALIBRATION FILE DOES NOT EXIST : '+file

  ; get new calibration data

  luts = 0
  pedestals = 0
  lut_map = 0
  energy_efficiency = 0
  count_calibration = 0
  energy_calibration = 0
  temperatures = 0

  RESTORE, file

  ; put this after restore in case restore fails

  calibration_file = file

END