;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_GET_PEDESTAL_HISTOGRAM
;
; Purpose     : Returns pedestal calibration data for a given detector, LUT, temperature.
;
; Explanation :	Returns pedestal calibration data for a given detector, LUT, temperature.
;               The pedestal calibration block contains pedestal histogram data for each integration
;               time together with info on the temperatures when they were taken.
;
; Use         : < pdata = ies_get_pedestal_histogram( times, integration_mode, detector, temp) >
;
; Inputs      : integration_mode : INT integration mode
;               detector         : INT detector number : 1-9
;               temp             : INT specifies temperature index of pedestal data.
;
; Opt. Inputs : None.
;
; Outputs     : pdata         : FLTARR(nbins) pedestal calibration data
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 12/10/00
;                 Adapted from ies get samples.
;                 Passed lut_map in ies pedestals argument list instead of picking up from calibration file.
;
; Modified    :	Version 0.1, 02/10/03
;                 Renamed from ies get pedestal.
;                 Renamed ies get temperature.
;                 Changed temp from keyword to argument and moved selection of temp for POLAR.
;                 Removed times from argument list.
;               Version 0.2, 04/12/03
;                 Removed lut_map from argument list and changed lut to integration mode.
;
; Version     :	Version 0.2, 04/12/03
;-
;**********************************************************

FUNCTION ies_get_pedestal_histogram, integration_mode, detector, temp

  COMMON pedestal_calibration_block, pedestals, temperatures, calibration_file

  ; return pedestal histogram data

  RETURN, REFORM(pedestals[detector-1,*,integration_mode,temp])

END