;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_GET_SAMPLE_LISTS
;
; Purpose     : Gets list of shifts with different peak maxima.
;
; Explanation :	Gets list of shifts with different peak maxima.
;
; Use         : < max_sample_lists=ies_get_sample_lists(samples) >
;
; Inputs      : samples           : FLTARR( npeds, nshifts) shifted pedestal data.
;
; Opt. Inputs : None.
;
; Outputs     : max_sample_lists : FLTARR(1+nshifts, npeds) list of shifts which produce peak in diffent pedestal channels.
;                                  Element 0 contains no. of shifts for each pedestal channe producing a peak in that channel.
;                                  Elements 1:* contain the shifts for each channel.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Written     :	Version 0.0, 21/11/03
;                 Adapted from rcs_get_samples.
;
; Modified    : Version 0.1, 24/01/04
;                 Changed max_sample_lists to an INT array
;
; Version     :	Version 0.1, 24/01/04
;-
;**********************************************************

FUNCTION ies_get_sample_lists, samples

  ; samples is FLTARR( npeds, nshifts)

  npeds = (SIZE(samples))[1]

  nshifts = (SIZE(samples))[2]

  ; set up max_sample_lists array
  ; get lists of samples indices at each maxima position
  ; 1st element contains no of samples
  ; these are used as look up tables to speed up search for shifted
  ; samples with the same peak as the actual data

  max_sample_lists = INTARR(1+nshifts, npeds)

  ; set up max_samples array
  ; max_samples contains the energy channel index of the peak for each shift
  ; this is used to restrict the search for max cross-correlation
  ; to samples with the same peak position as the data

  max_samples = FLTARR(nshifts)

  ; loop over shifts

  FOR b = 0, nshifts-1 DO BEGIN

    dummy = MAX ( samples[*,b], max_pos)

    max_samples[b] = max_pos

  ENDFOR

  ; get max sample lists
  ; this contains for each pedestal channel a list of the shifts which result in a peak in that channel

  FOR p = 0, npeds-1 DO BEGIN

    list = WHERE( max_samples EQ p, count)

    max_sample_lists[0,p] = count

    IF count GT 0 THEN max_sample_lists[1:count,p] = list

  ENDFOR

  RETURN, max_sample_lists

END