;+
; Project     :	CLUSTER - PEACE
;
; Name        :	IES_GETTICKS
;
; Purpose     :	Generates the number of ticks needed for a plot axis.
;
; Explanation :	The default number of ticks for a plot axis may be too small for a large plot
;               viewed through a window. This generates as many ticks as is sensible given the
;               actual device size. This number may then be used to set the variable !X/Y/Z.TICKS
;          
; Use         : < ticks = ies_getticks ( minx, maxx, nchars ) >
;
; Inputs      : minx    : minimum sample value in plot
;               maxx    : maximum sample value in plot
;               nchars  : size of plot window in characters 
;
; Opt. Inputs : None.
;
; Outputs     : ticks : number of ticks for plot
;               minx  : adjusted to suit tick range
;               maxx  : adjusted to suit tick range
;
; Opt. Outputs: None.
;
; Keywords    : None.
;
; Calls       :	None.
;                
; Common      :	None.
;
; Restrictions:	Doesnt work at present for range 250-500 ?
;               Extends it to 100-700 ?
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 2/6/95
;
; Modified    :	Version 0.1, 14/01/02
;                 Found compilation error under IDL 5.4 with use of CONTINUE statement !
;
; Version     :	Version 0.1, 14/01/02
;-
;**********************************************************

FUNCTION ies_getticks, minx, maxx, nchars

    ; get range of x values

    range = ABS ( maxx - minx )        

    ; select smallest power of 10 greater than range (works for both -ve and +ve power)

    power = ALOG10 ( range )         

    ; fix the decimal unit appropriate to the data

    IF ( power - FIX ( power ) ) GT 0.0 THEN power = FIX ( power ) ELSE power = FIX ( power )-1

    range = 10.0^power

    ; work out number of ticks which span range appropriateley

    ; force though while loop first time

    nticks = 0
    factor = 5 

    ; loop until get more than 4 ticks spanning range

    WHILE nticks LT 4 DO BEGIN

      CASE factor OF
        0 : range = range/2.0
        1 : range = range/2.5
        2 : range = range/2.0
        ELSE : 
      ENDCASE

      factor = (factor + 1) MOD 3

      iminx = FIX ( minx/range )
      imaxx = FIX ( maxx/range )

      IF iminx GT minx/range THEN iminx = iminx-1 
      IF imaxx LT maxx/range THEN imaxx = imaxx+1 

      nticks = imaxx - iminx 

    ENDWHILE

    ; set up new range for data

    minx = iminx*range
    maxx = imaxx*range

    ; check whether plot size is such that it is appropriate to use more ticks
    ; max. no of ticks is 29

    IF factor EQ 2 AND ((iminx MOD 2) OR (imaxx MOD 2)) THEN BEGIN

      IF nticks LE 5 THEN nticks = 5*nticks

    ENDIF ELSE BEGIN
  
      WHILE nchars/nticks GT 10 AND nticks LT 12 DO BEGIN

        CASE factor OF
          0 : nticks = nticks*2
          1 : nticks = nticks*2.5
          2 : nticks = nticks*2
          ELSE : 
        ENDCASE

        factor = (factor + 1) MOD 3

      ENDWHILE

    ENDELSE

    RETURN, FIX(nticks)

END
