;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_GOOD_DATA
;
; Purpose     :	Checks flags for good data.
;
; Explanation :	Checks flags for good data.
;
; Use         : <  >
;
; Inputs      :
;
; Opt. Inputs : None.
;
; Outputs     : output_array  : FLTARR(nsectors, ndetectors, nbands, npoints) containing processed data.
;
; Opt. Outputs:	None.
;
; Keywords    : REVERSE : flag indicating conversion back to counts required.
;
; Written     :	Version 0.0, Martin Carter, RAL, 07/02/02
;
; Modified    :	Version 0.1, 02/12/02
;                 Omitted first two bits of 2nd byte from bad data.
;                 This allows extrapolated data to be viewed as good data.
;
; Version     :	Version 0.1, 02/12/02
;-
;**********************************************************

FUNCTION ies_good_data, flags, COUNT=count

  ; previously used '70'X for RAPID and ies_sp_plot, ies_sinplot
  ; bit 8 is used in POLAR to flag dummy last data point
  ; changed from 'F0' to '3F0'

  RETURN, WHERE ( (flags AND '3F0'XL) EQ 0, count)

END
