;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_GUNZIP
;
; Purpose     :	Decompresses data file using gzip.
;
; Explanation :	Spawns Unix process to gzip data file. Decompresses even if file already
;               exist in tmp directory. Can be allowed to check if exists though and then not
;               decompress. Expects file extension .gz or .Z
;
; Use         : < ies_gunzip, filename, /CHECK >
;
; Inputs      : filename      : STRING file for compressing.
;
; Opt. Inputs : None.
;
; Outputs     : Compresses file.
;               filename      : STRING updates file name.
;
; Opt. Outputs:	None.
;
; Keywords    : CHECK : Flag indicating that should check first if decompressed file already exists.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 5/6/97
;
; Modified    :	Version 0.1, MKC, 28/8/97
;                 Added extension .Z
;               Version 0.2, 05/07/02
;                 Used new routine ies_file_exists.
;               Version 0.3, 11/07/02
;                 Used ies_spawn.
;               Version 0.4, 02/10/03
;                 Changed environment variable for temporary directory.
;                 Changed printout.
;               Version 0.5, 08/01/04
;                 Added some  quote marks to allow PC file names with blanks.
;
; Version     :	Version 0.5, 08/01/04
;-
;**********************************************************

PRO ies_gunzip, filename, CHECK=check

  ; check file extension

  IF STRPOS(filename,'.gz') GT 0 THEN endpos = STRPOS(filename,'.gz') ELSE $
  IF STRPOS(filename,'.Z')  GT 0 THEN endpos = STRPOS(filename,'.Z') ELSE $
    MESSAGE, 'Invalid file extension for compressed file', /TRACEBACK

  ; set up file name for uncompressed data

  newfile = concat_dir ( GETENV('TEMPORARY_DIR'), strip_dirname(STRMID(filename,0,endpos)) )

  ; check if newfile already exists or forced to recreate

  IF NOT ies_file_exists(newfile) OR NOT KEYWORD_SET(check) THEN BEGIN

    ; spawn Unix process

    PRINT, 'Decompressing file ' + filename

    IF ies_spawn('gzip -d -c "' + filename + '" > "' + newfile + '"') THEN MESSAGE, 'GZIP FAILED'

  ENDIF ELSE BEGIN

    PRINT, 'Decompressed file already exists : '+newfile

  ENDELSE

  ; point to new file

  filename = newfile

END
