;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_GZIP
;
; Purpose     :	Compresses data file using gzip.
;
; Explanation :	Spawns Unix process to gzip data file.
;
; Use         : < ies_gzip, filename >
;
; Inputs      : filename      : STRING file for compressing.
;
; Opt. Inputs : None.
;
; Outputs     : Compresses file.
;               filename      : STRING updates file name.
;
; Opt. Outputs:	None.
;
; Keywords    : None.
;
; Calls       :	None.
;
; Common      : None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Display.
;
; Prev. Hist. :	None.
;
; Written     :	Version 0.0, Martin Carter, RAL, 5/6/97
;
; Modified    :	Version 0.1, 11/07/02
;                 Used ies_spawn.
;               Version 0.2, 02/10/03
;                 Allow gzip to fail without stopping.
;                 Changed printout.
;
; Version     :	Version 0.2, 02/10/03
;-
;**********************************************************

PRO ies_gzip, filename

  PRINT, 'Compressing file ' + filename

  ; spawn Unix process

  IF ies_spawn('gzip -f ' + filename) THEN MESSAGE, 'GZIP FAILED', /INFORMATIONAL ELSE filename = filename + '.gz'

END
