;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_INSTRUMENT
;
; Purpose     :	Tests datatype for SC and instrument.
;
; Explanation :	Tests datatype for SC and instrument.
;
; Use         : < res = ies_instrument(datatype) >
;
; Inputs      : None.
;
; Opt. Inputs : None.
;
; Outputs     : res : FLAG 0 : No
;                          1 : Yes
;
; Opt. Outputs:	None.
;
; Prev. Hist. :	Previously in-line code.
;
; Written     :	Version 0.0, Martin Carter, RAL, 30/09/03
;
; Modified    :	None.
;
; Version     :	Version 0.0, 30/09/03
;-
;**********************************************************

FUNCTION ies_instrument, datatype, RAPID=rapid, IES=ies, I3DD=i3dd, IIMS=iims, $
                                   HIST=hist, IPS=ips, POLAR=polar, EHIST=ehist, $
                                   PHIST=phist, HI3DD=hi3dd

  IF KEYWORD_SET(rapid)     THEN RETURN, STRPOS(datatype,'RAPID') GE 0

  IF KEYWORD_SET(ies)       THEN RETURN, STRPOS(datatype,'IES') GE 0

  IF KEYWORD_SET(i3dd)      THEN RETURN, STRPOS(datatype,'I3DD') GE 0

  IF KEYWORD_SET(iims)      THEN RETURN, STRPOS(datatype,'IIMS') GE 0

  IF KEYWORD_SET(hist)      THEN RETURN, STRPOS(datatype,'HIST') GE 0

  IF KEYWORD_SET(ips)       THEN RETURN, STRPOS(datatype,'IPS') GE 0

  IF KEYWORD_SET(polar)     THEN RETURN, STRPOS(datatype,'POLAR') GE 0

  IF KEYWORD_SET(ehist)     THEN RETURN, STRPOS(datatype,'HISTe') GE 0

  IF KEYWORD_SET(phist)     THEN RETURN, STRPOS(datatype,'HISTp') GE 0

  IF KEYWORD_SET(hi3dd)     THEN RETURN, STRPOS(datatype,'I3DD_H') GE 0

  MESSAGE, 'IMPLEMENTATION ERROR'

END
