
FUNCTION ies_interpol, v, x, u

  nv = N_ELEMENTS(v)
  nx = N_ELEMENTS(x)
  nu = N_ELEMENTS(u)

  IF nx NE nv THEN MESSAGE, 'V and X arrays must have same # of elements'

  IF nx LT 2 THEN MESSAGE, 'Invalid # of elements for interpolation'

  ; s[i] contains index of sample to use to interpolate for u[i]
  ; ie use s[i]-1 and s[i]

  s = LONARR(nu)

  ; if u[k] LE x[1] then use {0,1}

  j = 1

  FOR k = 0, nu-1 DO BEGIN

LOOP:

    IF j EQ nx-1 THEN BEGIN

      ; u[k] beyond x[nx-2] : use {nx-2, nx-1} and extrapolate if necessary

    ENDIF ELSE IF x[j] LE u[k] THEN BEGIN

      ; carry on 'til get first sample beyond u[k]

      j = j + 1

      GOTO, LOOP

    ENDIF

    ; x[j] GT u[k] or u[k] GT x[nx-1] and j=nx-1
    ; either way use {j-1,j} for interpolation/extrapolation

    s[k] = j

  ENDFOR

  ; u[k] is between x[s[k]-1] and x[s[k]]

  p = (u-x[s-1])*(v[s]-v[s-1])/(x[s] - x[s-1]) + v[s-1]

  RETURN, p

END
