;+
; Project     :	CLUSTER - RAPID
;
; Name        :	IES_LIST_SAMPLES
;
; Purpose     :	Gets list of samples on/after specified time.
;
; Explanation : Gets list of samples on/after specified time.
;
; Use         : < ies_plot_angleangle, xsiz, ysiz, ytop, ncolors, ncolumns, WIDGET=widget >
;
; Inputs      : None.
;
; Opt. Inputs : xsiz : FLOAT
;               ysiz : FLOAT
;               ytop : FLOAT
;               ncolors : INT
;               ncolumns : INT
;
; Outputs     : Displays plots in window.
;
; Opt. Outputs:
;
; Keywords    : WIDGET  : Flag for widget rather than window output.
;
; Prev. Hist. :	Combined IES_PLOT and IES_WINDOW_PLOT versions.
;
; Written     :	Version 0.0, Martin Carter, RAL, 06/10/03
;                 Adapted from ies angleangle and ies timeline.
;                 Previously used slightly different time comparison.
;
; Modified    :	None
;
; Version     :	Version 0.0, 06/10/03
;-
;**********************************************************

FUNCTION ies_list_samples, time, header, data, NOBAD=nobad, COUNT=count, WIDGET=widget

  ; get list of good data

  IF KEYWORD_SET(nobad) THEN BEGIN

    good_list = ies_good_data(data.flag, COUNT=count)

    IF count EQ 0 THEN RETURN, [-1]

  ENDIF ELSE BEGIN

    ; NB last point displayed
    ; however last point may be dummy

    count = header.npoints

    good_list = LINDGEN(count)

  ENDELSE

  ; get corresponding sample
  ; previously used : list = WHERE ( data[good_list].time LT time, count)
  ; and used the last sample from the list.
  ; This ensures that the sample before the cursor is displayed but means that the first sample was never displayed

  list = WHERE ( data[good_list].time GE time, count)

  ; The current scheme ensures that list contains the good samples following cursor position but need to add the sample
  ; before the first in the list. If no samples in list need to set list to last good sample.

  IF count   EQ 0 THEN BEGIN

    count = 1

    RETURN, last_item(good_list)

  ENDIF ELSE IF list[0] GT 0 THEN BEGIN

    count = count+1

    RETURN, good_list[[list[0]-1,list]]

  ENDIF ELSE BEGIN

    RETURN, good_list[list]

  ENDELSE

END