;+
; Project     :	CLUSTER - RAPID, POLAR - CEPPAD
;
; Name        :	IES_LUT_LIST
;
; Purpose     :	Creates structure array giving LUT run information.
;
; Explanation :	Creates structure array giving LUT run information.
;
; Use         : < lut_list = ies_lut_list(luts, max_lut) >
;
; Inputs      : luts  : BYTARR LUT for each sample point.
;
; Opt. Inputs : nluts : max allowed value of LUT
;
; Outputs     : lut_list : STRUCTURE ARRAY of {index,lut,size}
;
; Opt. Outputs:	None.
;
; Keywords    : None
;
; Prev. Hist. :	Inline code in various places ie ies div.
;
; Written     :	Version 0.0, Martin Carter, RAL, 24/10/03
;                 Adapted from ies div.
;
; Modified    : Version 0.1, 06/11/03
;                 Added .size tag.
;               Version 0.2, 30/11/03
;                 Fixed bug in which start of run = end of last run.
;
; Version     :	Version 0.2, 30/11/03
;-
;**********************************************************

FUNCTION ies_lut_list, luts, nluts

  ; get list of ends of runs of luts

  run_list = ies_runs(luts)

  ; set up no .of runs

  nruns = N_ELEMENTS(run_list)

  ; set up structure array

  lut_list = REPLICATE({st:0L,en:0L,size:0L,lut:0},nruns)

  ; set up tags

  IF nruns GT 1 THEN lut_list[1:*].st = run_list[0:nruns-2] + 1

  lut_list.en = run_list

  lut_list.size = lut_list.en - lut_list.st + 1

  lut_list.lut = luts[run_list]

  ; check for invalid luts

  list = WHERE(lut_list.lut EQ -1, count)

  ; fix bad luts
  ; set bad lut to previous lut
  ; if no previous lut set to zero
  ; do loop forces ordering

  FOR l = 0L, count-1 DO lut_list[list[l]].lut = lut_list[(list[l]-1) > 0].lut > 0

  ; check for invalid luts

  IF N_ELEMENTS(nluts) GT 0 THEN BEGIN

    list = WHERE(lut_list.lut GT nluts, count)

    IF count GT 0 THEN BEGIN

      PRINT, 'WARNING, invalid lut = ', lut_list[list].lut

      lut_list[list].lut = 0

    ENDIF

  ENDIF

  ; return

  RETURN, lut_list

END
